/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.TransportChannelListener;
import org.activemq.transport.TransportServerChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransportServerChannelSupport
implements TransportServerChannel {
    private static final Log log = LogFactory.getLog((Class)TransportServerChannelSupport.class);
    private String url;
    private TransportChannelListener transportChannelListener;
    private List channels = new CopyOnWriteArrayList();

    public TransportServerChannelSupport(URI url) {
        this(url.toString());
    }

    public TransportServerChannelSupport(String url) {
        this.url = url;
    }

    public void start() throws JMSException {
        if (this.transportChannelListener == null) {
            throw new JMSException("Must have a TransportChannelListener attached!");
        }
    }

    public synchronized void stop() throws JMSException {
        Iterator iter = this.channels.iterator();
        while (iter.hasNext()) {
            WeakReference channelRef = (WeakReference)iter.next();
            TransportChannel channel = (TransportChannel)channelRef.get();
            if (channel == null) continue;
            channel.stop();
        }
    }

    public TransportChannelListener getTransportChannelListener() {
        return this.transportChannelListener;
    }

    public void setTransportChannelListener(TransportChannelListener listener) {
        this.transportChannelListener = listener;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public synchronized void addClient(TransportChannel channel) {
        if (this.transportChannelListener == null) {
            log.warn((Object)("No listener attached, cannot add channel: " + channel));
        } else {
            this.transportChannelListener.addClient(channel);
            channel.setTransportChannelListener(this.transportChannelListener);
            this.channels.add(new WeakReference<TransportChannel>(channel));
        }
    }

    public synchronized void removeClient(TransportChannel channel) {
        Iterator iter = this.channels.iterator();
        while (iter.hasNext()) {
            WeakReference channelRef = (WeakReference)iter.next();
            TransportChannel c = (TransportChannel)channelRef.get();
            if (c == null || !c.equals(channel)) continue;
            this.channels.remove(channelRef);
            break;
        }
    }

    protected String resolveHostName(String hostName) {
        String result = hostName;
        try {
            if (hostName != null && (hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1"))) {
                result = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException e) {
            log.debug((Object)"failed to resolve hostname", (Throwable)e);
        }
        return result;
    }
}

