/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQPrefetchPolicy {
    private static final Log log = LogFactory.getLog((Class)ActiveMQPrefetchPolicy.class);
    private static final int MAX_PREFETCH_SIZE = 32766;
    private int queuePrefetch = 1000;
    private int queueBrowserPrefetch = 500;
    private int topicPrefetch = 1000;
    private int durableTopicPrefetch = 100;

    public int getDurableTopicPrefetch() {
        return this.durableTopicPrefetch;
    }

    public void setDurableTopicPrefetch(int durableTopicPrefetch) {
        this.durableTopicPrefetch = this.getMaxPrefetchLimit(durableTopicPrefetch);
    }

    public int getQueuePrefetch() {
        return this.queuePrefetch;
    }

    public void setQueuePrefetch(int queuePrefetch) {
        this.queuePrefetch = this.getMaxPrefetchLimit(queuePrefetch);
    }

    public int getQueueBrowserPrefetch() {
        return this.queueBrowserPrefetch;
    }

    public void setQueueBrowserPrefetch(int queueBrowserPrefetch) {
        this.queueBrowserPrefetch = this.getMaxPrefetchLimit(queueBrowserPrefetch);
    }

    public int getTopicPrefetch() {
        return this.topicPrefetch;
    }

    public void setTopicPrefetch(int topicPrefetch) {
        this.topicPrefetch = this.getMaxPrefetchLimit(topicPrefetch);
    }

    private int getMaxPrefetchLimit(int value) {
        int result = Math.min(value, 32766);
        if (result < value) {
            log.warn((Object)("maximum prefetch limit has been reset from " + value + " to " + 32766));
        }
        return result;
    }
}

