/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQMessageConsumer;
import org.activemq.ActiveMQMessageDispatcher;
import org.activemq.ActiveMQMessageProducer;
import org.activemq.ActiveMQMessageTransformation;
import org.activemq.ActiveMQQueueBrowser;
import org.activemq.ActiveMQQueueReceiver;
import org.activemq.ActiveMQQueueSender;
import org.activemq.ActiveMQSessionExecutor;
import org.activemq.ActiveMQTopicPublisher;
import org.activemq.ActiveMQTopicSubscriber;
import org.activemq.TransactionContext;
import org.activemq.io.util.ByteArray;
import org.activemq.io.util.ByteArrayCompression;
import org.activemq.io.util.ByteArrayFragmentation;
import org.activemq.management.JMSSessionStatsImpl;
import org.activemq.management.StatsCapable;
import org.activemq.management.StatsImpl;
import org.activemq.message.ActiveMQBytesMessage;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMapMessage;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQObjectMessage;
import org.activemq.message.ActiveMQQueue;
import org.activemq.message.ActiveMQStreamMessage;
import org.activemq.message.ActiveMQTemporaryQueue;
import org.activemq.message.ActiveMQTemporaryTopic;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.ActiveMQTopic;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.DurableUnsubscribe;
import org.activemq.message.MessageAck;
import org.activemq.message.MessageAcknowledge;
import org.activemq.message.ProducerInfo;
import org.activemq.service.impl.DefaultQueueList;
import org.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQSession
implements Session,
QueueSession,
TopicSession,
ActiveMQMessageDispatcher,
MessageAcknowledge,
StatsCapable {
    protected static final int CONSUMER_DISPATCH_UNSET = 1;
    protected static final int CONSUMER_DISPATCH_ASYNC = 2;
    protected static final int CONSUMER_DISPATCH_SYNC = 3;
    private static final Log log = LogFactory.getLog((Class)ActiveMQSession.class);
    protected ActiveMQConnection connection;
    protected int acknowledgeMode;
    protected CopyOnWriteArrayList consumers;
    protected CopyOnWriteArrayList producers;
    private IdGenerator temporaryDestinationGenerator;
    private MessageListener messageListener;
    protected boolean closed;
    private SynchronizedBoolean started;
    private short sessionId;
    private long startTime;
    private DefaultQueueList deliveredMessages;
    private ActiveMQSessionExecutor messageExecutor;
    private JMSSessionStatsImpl stats;
    private int consumerDispatchState;
    private ByteArrayCompression compression;
    private ByteArrayFragmentation fragmentation;
    private Map assemblies;
    private TransactionContext transactionContext;
    private boolean internalSession;
    private DeliveryListener deliveryListener;

    protected ActiveMQSession(ActiveMQConnection theConnection, int theAcknowledgeMode) throws JMSException {
        this(theConnection, theAcknowledgeMode, theConnection.isOptimizedMessageDispatch());
    }

    protected ActiveMQSession(ActiveMQConnection theConnection, int theAcknowledgeMode, boolean optimizedDispatch) throws JMSException {
        this.connection = theConnection;
        this.acknowledgeMode = theAcknowledgeMode;
        this.setTransactionContext(new TransactionContext(theConnection));
        this.consumers = new CopyOnWriteArrayList();
        this.producers = new CopyOnWriteArrayList();
        this.temporaryDestinationGenerator = new IdGenerator();
        this.started = new SynchronizedBoolean(false);
        this.sessionId = this.connection.generateSessionId();
        this.startTime = System.currentTimeMillis();
        this.deliveredMessages = new DefaultQueueList();
        this.messageExecutor = new ActiveMQSessionExecutor(this, this.connection.getMemoryBoundedQueue("Session(" + this.sessionId + ")"));
        this.messageExecutor.setOptimizedMessageDispatch(optimizedDispatch);
        this.connection.addSession(this);
        this.stats = new JMSSessionStatsImpl((List)this.producers, (List)this.consumers);
        this.consumerDispatchState = 1;
        this.compression = new ByteArrayCompression();
        this.compression.setCompressionLevel(theConnection.getMessageCompressionLevel());
        this.compression.setCompressionStrategy(theConnection.getMessageCompressionStrategy());
        this.compression.setCompressionLimit(theConnection.getMessageCompressionLimit());
        this.fragmentation = new ByteArrayFragmentation();
        this.fragmentation.setFragmentationLimit(theConnection.getMessageFragmentationLimit());
        this.assemblies = new ConcurrentHashMap();
        this.internalSession = theConnection.isInternalConnection();
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        if (this.transactionContext != null) {
            this.transactionContext.removeSession(this);
        }
        this.transactionContext = transactionContext;
        this.transactionContext.addSession(this);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public StatsImpl getStats() {
        return this.stats;
    }

    public JMSSessionStatsImpl getSessionStats() {
        return this.stats;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQMapMessage();
    }

    public Message createMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        this.checkClosed();
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        msg.setObject(object);
        return msg;
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        this.checkClosed();
        return new ActiveMQTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        this.checkClosed();
        ActiveMQTextMessage msg = new ActiveMQTextMessage();
        msg.setText(text);
        return msg;
    }

    public boolean getTransacted() throws JMSException {
        this.checkClosed();
        return this.acknowledgeMode == 0 || this.transactionContext.isInXATransaction();
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkClosed();
        return this.acknowledgeMode;
    }

    public void commit() throws JMSException {
        this.checkClosed();
        if (!this.getTransacted()) {
            throw new IllegalStateException("Not a transacted session");
        }
        this.transactionContext.commit();
    }

    public void rollback() throws JMSException {
        this.checkClosed();
        if (!this.getTransacted()) {
            throw new IllegalStateException("Not a transacted session");
        }
        this.transactionContext.rollback();
    }

    public void clearDeliveredMessages() {
        this.deliveredMessages.clear();
    }

    public void close() throws JMSException {
        if (!this.closed) {
            if (this.getTransactionContext().isInLocalTransaction()) {
                this.rollback();
            }
            this.doClose();
            this.closed = true;
        }
    }

    protected void doClose() throws JMSException {
        this.doAcknowledge(true);
        this.deliveredMessages.clear();
        Iterator i = this.consumers.iterator();
        while (i.hasNext()) {
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)i.next();
            consumer.close();
        }
        i = this.producers.iterator();
        while (i.hasNext()) {
            ActiveMQMessageProducer producer = (ActiveMQMessageProducer)i.next();
            producer.close();
        }
        this.consumers.clear();
        this.producers.clear();
        this.connection.removeSession(this);
        this.messageExecutor.close();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("The Session is closed");
        }
    }

    public void recover() throws JMSException {
        this.checkClosed();
        if (this.getTransacted()) {
            throw new IllegalStateException("This session is transacted");
        }
        this.redeliverUnacknowledgedMessages();
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkClosed();
        return this.messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        this.checkClosed();
        this.messageListener = listener;
        if (listener != null) {
            this.messageExecutor.setDispatchedBySessionPool(true);
        }
    }

    public void run() {
        ActiveMQMessage message;
        while ((message = this.messageExecutor.dequeueNoWait()) != null) {
            if (this.deliveryListener != null) {
                this.deliveryListener.beforeDelivery(this, message);
            }
            this.beforeMessageDelivered(message);
            this.deliver(message);
            if (this.deliveryListener == null) continue;
            this.deliveryListener.afterDelivery(this, message);
        }
    }

    private void deliver(ActiveMQMessage message) {
        if ((message = this.assembleMessage(message)) != null && !message.isExpired() && this.messageListener != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message delivered to session message listener: " + message));
                }
                this.messageListener.onMessage((Message)message);
                this.afterMessageDelivered(true, message, true, false, true);
            }
            catch (Throwable t) {
                log.info((Object)("Caught :" + t), t);
                this.afterMessageDelivered(true, message, false, false, true);
            }
        } else {
            this.afterMessageDelivered(true, message, false, message.isExpired(), true);
        }
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        this.checkClosed();
        return new ActiveMQMessageProducer(this, ActiveMQMessageTransformation.transformDestination(destination));
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        this.checkClosed();
        int prefetch = destination instanceof Topic ? this.connection.getPrefetchPolicy().getTopicPrefetch() : this.connection.getPrefetchPolicy().getQueuePrefetch();
        return new ActiveMQMessageConsumer(this, ActiveMQMessageTransformation.transformDestination(destination), "", "", this.connection.getNextConsumerNumber(), prefetch, false, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        this.checkClosed();
        int prefetch = destination instanceof Topic ? this.connection.getPrefetchPolicy().getTopicPrefetch() : this.connection.getPrefetchPolicy().getQueuePrefetch();
        return new ActiveMQMessageConsumer(this, ActiveMQMessageTransformation.transformDestination(destination), "", messageSelector, this.connection.getNextConsumerNumber(), prefetch, false, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        this.checkClosed();
        int prefetch = this.connection.getPrefetchPolicy().getTopicPrefetch();
        return new ActiveMQMessageConsumer(this, ActiveMQMessageTransformation.transformDestination(destination), "", messageSelector, this.connection.getNextConsumerNumber(), prefetch, NoLocal, false);
    }

    public Queue createQueue(String queueName) throws JMSException {
        this.checkClosed();
        return new ActiveMQQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        this.checkClosed();
        return new ActiveMQTopic(topicName);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        this.checkClosed();
        return new ActiveMQTopicSubscriber(this, ActiveMQMessageTransformation.transformDestination((Destination)topic), name, "", this.connection.getNextConsumerNumber(), this.connection.getPrefetchPolicy().getDurableTopicPrefetch(), false, false);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        return new ActiveMQTopicSubscriber(this, ActiveMQMessageTransformation.transformDestination((Destination)topic), name, messageSelector, this.connection.getNextConsumerNumber(), this.connection.getPrefetchPolicy().getDurableTopicPrefetch(), noLocal, false);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkClosed();
        return new ActiveMQQueueBrowser(this, (ActiveMQQueue)ActiveMQMessageTransformation.transformDestination((Destination)queue), "", this.connection.getNextConsumerNumber());
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        return new ActiveMQQueueBrowser(this, (ActiveMQQueue)ActiveMQMessageTransformation.transformDestination((Destination)queue), messageSelector, this.connection.getNextConsumerNumber());
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkClosed();
        String tempQueueName = "TemporaryQueue-" + ActiveMQDestination.createTemporaryName(this.connection.getInitializedClientID());
        tempQueueName = tempQueueName + this.temporaryDestinationGenerator.generateId();
        ActiveMQTemporaryQueue tempQueue = new ActiveMQTemporaryQueue(tempQueueName);
        tempQueue.setSessionCreatedBy(this);
        this.connection.startTemporaryDestination(tempQueue);
        return tempQueue;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkClosed();
        String tempTopicName = "TemporaryTopic-" + ActiveMQDestination.createTemporaryName(this.connection.getInitializedClientID());
        tempTopicName = tempTopicName + this.temporaryDestinationGenerator.generateId();
        ActiveMQTemporaryTopic tempTopic = new ActiveMQTemporaryTopic(tempTopicName);
        tempTopic.setSessionCreatedBy(this);
        this.connection.startTemporaryDestination(tempTopic);
        return tempTopic;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        this.checkClosed();
        return new ActiveMQQueueReceiver(this, ActiveMQDestination.transformDestination((Destination)queue), "", this.connection.getNextConsumerNumber(), this.connection.getPrefetchPolicy().getQueuePrefetch());
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        this.checkClosed();
        return new ActiveMQQueueReceiver(this, ActiveMQMessageTransformation.transformDestination((Destination)queue), messageSelector, this.connection.getNextConsumerNumber(), this.connection.getPrefetchPolicy().getQueuePrefetch());
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        this.checkClosed();
        return new ActiveMQQueueSender(this, ActiveMQMessageTransformation.transformDestination((Destination)queue));
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkClosed();
        return new ActiveMQTopicSubscriber(this, ActiveMQMessageTransformation.transformDestination((Destination)topic), null, null, this.connection.getNextConsumerNumber(), this.connection.getPrefetchPolicy().getTopicPrefetch(), false, false);
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkClosed();
        return new ActiveMQTopicSubscriber(this, ActiveMQMessageTransformation.transformDestination((Destination)topic), null, messageSelector, this.connection.getNextConsumerNumber(), this.connection.getPrefetchPolicy().getTopicPrefetch(), noLocal, false);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        this.checkClosed();
        return new ActiveMQTopicPublisher(this, ActiveMQMessageTransformation.transformDestination((Destination)topic));
    }

    public void unsubscribe(String name) throws JMSException {
        this.checkClosed();
        DurableUnsubscribe ds = new DurableUnsubscribe();
        ds.setClientId(this.connection.getClientID());
        ds.setSubscriberName(name);
        this.connection.syncSendPacket(ds);
    }

    public boolean isTarget(ActiveMQMessage message) {
        Iterator i = this.consumers.iterator();
        while (i.hasNext()) {
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)i.next();
            if (!message.isConsumerTarget(consumer.getConsumerNumber())) continue;
            return true;
        }
        return false;
    }

    public void dispatch(ActiveMQMessage message) {
        if ((message = this.assembleMessage(message)) != null) {
            message.setMessageAcknowledge(this);
            this.messageExecutor.execute(message);
        }
    }

    public void acknowledge(ActiveMQMessage caller) throws JMSException {
        this.checkClosed();
        ActiveMQMessage msg = (ActiveMQMessage)this.deliveredMessages.get(caller);
        if (msg != null) {
            msg.setMessageConsumed(true);
        }
        this.doAcknowledge(false);
    }

    protected void doAcknowledge(boolean isClosing) throws JMSException {
        if (!this.closed && this.acknowledgeMode == 2) {
            ActiveMQMessage msg = null;
            while ((msg = (ActiveMQMessage)this.deliveredMessages.removeFirst()) != null) {
                boolean messageConsumed;
                boolean bl = messageConsumed = isClosing ? false : msg.isMessageConsumed();
                if (!msg.isTransientConsumed()) {
                    this.sendMessageAck(msg, messageConsumed, false);
                    continue;
                }
                if (messageConsumed) continue;
                this.connection.addToTransientConsumedRedeliverCache(msg);
            }
            this.deliveredMessages.clear();
        }
    }

    protected void beforeMessageDelivered(ActiveMQMessage message) {
        if (message != null && !this.closed) {
            this.deliveredMessages.add(message);
        }
    }

    protected void afterMessageDelivered(boolean sendAcknowledge, ActiveMQMessage message, boolean messageConsumed, boolean messageExpired, boolean beforeCalled) {
        if (message != null && !this.closed) {
            if (this.isClientAcknowledge() && !messageExpired || this.isTransacted() && message.isTransientConsumed()) {
                message.setMessageConsumed(messageConsumed);
                if (!beforeCalled) {
                    this.deliveredMessages.add(message);
                }
            } else if (beforeCalled) {
                this.deliveredMessages.remove(message);
            }
            if (sendAcknowledge && !this.isClientAcknowledge()) {
                try {
                    this.doStartTransaction();
                    this.sendMessageAck(message, messageConsumed, messageExpired);
                }
                catch (JMSException e) {
                    log.warn((Object)"failed to notify Broker that message is delivered", (Throwable)e);
                }
            }
        }
    }

    public void removeTemporaryDestination(ActiveMQDestination destination) throws JMSException {
        this.connection.stopTemporaryDestination(destination);
    }

    private void sendMessageAck(ActiveMQMessage message, boolean messageConsumed, boolean messageExpired) throws JMSException {
        if (message.isMessagePart()) {
            ActiveMQMessage[] parts = (ActiveMQMessage[])this.assemblies.remove(message.getParentMessageID());
            if (parts != null) {
                for (int i = 0; i < parts.length; ++i) {
                    parts[i].setConsumerIdentifer(message.getConsumerIdentifer());
                    this.doSendMessageAck(parts[i], messageConsumed, messageExpired);
                }
            } else {
                JMSException jmsEx = new JMSException("Could not find parts for fragemented message: " + message);
                this.connection.onException(jmsEx);
            }
        } else {
            this.doSendMessageAck(message, messageConsumed, messageExpired);
        }
    }

    private void doSendMessageAck(ActiveMQMessage message, boolean messageConsumed, boolean messageExpired) throws JMSException {
        if (message != null && !message.isAdvisory()) {
            MessageAck ack = new MessageAck();
            ack.setConsumerId(message.getConsumerIdentifer());
            ack.setTransactionId(this.transactionContext.getTransactionId());
            ack.setExternalMessageId(message.isExternalMessageId());
            ack.setMessageID(message.getJMSMessageID());
            ack.setSequenceNumber(message.getSequenceNumber());
            ack.setProducerKey(message.getProducerKey());
            ack.setMessageRead(messageConsumed);
            ack.setDestination(message.getJMSActiveMQDestination());
            ack.setPersistent(message.getJMSDeliveryMode() == 2);
            ack.setExpired(messageExpired);
            ack.setSessionId(this.getSessionId());
            this.connection.asyncSendPacket(ack);
        }
    }

    protected void addConsumer(ActiveMQMessageConsumer consumer) throws JMSException {
        this.connection.sendConnectionInfoToBroker();
        if (consumer.isDurableSubscriber()) {
            this.stats.onCreateDurableSubscriber();
        }
        ConsumerInfo info = this.createConsumerInfo(consumer);
        info.setStarted(true);
        this.consumers.add((Object)consumer);
        if (this.started.get()) {
            this.connection.replayTransientConsumedRedeliveredMessages(this, consumer);
        }
        try {
            this.connection.syncSendPacket(info);
        }
        catch (JMSException jmsEx) {
            this.consumers.remove((Object)consumer);
            throw jmsEx;
        }
    }

    protected void removeConsumer(ActiveMQMessageConsumer consumer) throws JMSException {
        this.consumers.remove((Object)consumer);
        if (consumer.isDurableSubscriber()) {
            this.stats.onRemoveDurableSubscriber();
        }
        if (!this.closed) {
            ConsumerInfo info = this.createConsumerInfo(consumer);
            info.setStarted(false);
            this.connection.asyncSendPacket(info, false);
        }
    }

    protected ConsumerInfo createConsumerInfo(ActiveMQMessageConsumer consumer) throws JMSException {
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(consumer.consumerIdentifier);
        info.setClientId(this.connection.clientID);
        info.setSessionId(this.sessionId);
        info.setConsumerNo(consumer.consumerNumber);
        info.setPrefetchNumber(consumer.prefetchNumber);
        info.setDestination(consumer.destination);
        info.setNoLocal(consumer.noLocal);
        info.setBrowser(consumer.browser);
        info.setSelector(consumer.messageSelector);
        info.setStartTime(consumer.startTime);
        info.setConsumerName(consumer.consumerName);
        return info;
    }

    protected void addProducer(ActiveMQMessageProducer producer) throws JMSException {
        this.connection.sendConnectionInfoToBroker();
        this.connection.startAdvisoryForTempDestination(producer.defaultDestination);
        producer.setProducerId(this.connection.handleIdGenerator.getNextShortSequence());
        ProducerInfo info = this.createProducerInfo(producer);
        info.setStarted(true);
        this.connection.syncSendPacket(info);
        this.producers.add((Object)producer);
    }

    protected void removeProducer(ActiveMQMessageProducer producer) throws JMSException {
        this.producers.remove((Object)producer);
        if (!this.closed) {
            this.connection.stopAdvisoryForTempDestination(producer.defaultDestination);
            ProducerInfo info = this.createProducerInfo(producer);
            info.setStarted(false);
            this.connection.asyncSendPacket(info, false);
        }
    }

    protected ProducerInfo createProducerInfo(ActiveMQMessageProducer producer) throws JMSException {
        ProducerInfo info = new ProducerInfo();
        info.setProducerId(producer.getProducerId());
        info.setClientId(this.connection.clientID);
        info.setSessionId(this.sessionId);
        info.setDestination(producer.defaultDestination);
        info.setStartTime(producer.getStartTime());
        return info;
    }

    protected void start() throws JMSException {
        this.started.set(true);
        Iterator i = this.consumers.iterator();
        while (i.hasNext()) {
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)i.next();
            this.connection.replayTransientConsumedRedeliveredMessages(this, consumer);
        }
        this.messageExecutor.start();
    }

    protected void stop() {
        this.started.set(false);
        this.messageExecutor.stop();
    }

    protected short getSessionId() {
        return this.sessionId;
    }

    protected void setSessionId(short sessionId) {
        this.sessionId = sessionId;
    }

    protected long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    protected void send(ActiveMQMessageProducer producer, Destination destination, Message message, int deliveryMode, int priority, long timeToLive, boolean reuseMessageId) throws JMSException {
        boolean fragmentedMessage;
        this.checkClosed();
        this.connection.sendConnectionInfoToBroker();
        this.doStartTransaction();
        message.setJMSDestination(destination);
        message.setJMSDeliveryMode(deliveryMode);
        message.setJMSPriority(priority);
        long expiration = 0L;
        if (!producer.getDisableMessageTimestamp()) {
            long timeStamp = System.currentTimeMillis();
            message.setJMSTimestamp(timeStamp);
            if (timeToLive > 0L) {
                expiration = timeToLive + timeStamp;
            }
        }
        message.setJMSExpiration(expiration);
        String id = message.getJMSMessageID();
        String producerKey = producer.getProducerMessageKey();
        long sequenceNumber = producer.getIdGenerator().getNextSequence();
        if (id == null || id.length() == 0 || !producer.getDisableMessageID() && !reuseMessageId) {
            message.setJMSMessageID(producerKey + sequenceNumber);
        }
        ActiveMQMessage msg = ActiveMQMessageTransformation.transformMessage(message);
        if (this.connection.isCopyMessageOnSend()) {
            msg = msg.shallowCopy();
        }
        msg.setJMSMessageIdentity(null);
        msg.setExternalMessageId(id != null);
        msg.setSequenceNumber(sequenceNumber);
        msg.setProducerKey(producerKey);
        msg.setTransactionId(this.transactionContext.getTransactionId());
        msg.setJMSClientID(this.connection.clientID);
        msg.setMesssageHandle(producer.getProducerId());
        msg.setJMSRedelivered(false);
        if (!this.connection.isInternalConnection()) {
            msg.clearBrokersVisited();
            this.connection.validateDestination(msg.getJMSActiveMQDestination());
        }
        if (this.connection.isPrepareMessageBodyOnSend()) {
            msg.prepareMessageBody();
        }
        if (this.connection.isDoMessageCompression()) {
            try {
                msg.getBodyAsBytes(this.compression);
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException("Failed to compress message payload");
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
        }
        if ((fragmentedMessage = this.connection.isDoMessageFragmentation()) && !msg.isMessagePart()) {
            try {
                fragmentedMessage = this.fragmentation.doFragmentation(msg.getBodyAsBytes());
                if (fragmentedMessage) {
                    ByteArray[] array = this.fragmentation.fragment(msg.getBodyAsBytes());
                    String parentMessageId = msg.getJMSMessageID();
                    for (int i = 0; i < array.length; ++i) {
                        ActiveMQMessage fragment = msg.shallowCopy();
                        fragment.setJMSMessageID(null);
                        fragment.setMessagePart(true);
                        fragment.setParentMessageID(parentMessageId);
                        fragment.setNumberOfParts((short)array.length);
                        fragment.setPartNumber((short)i);
                        if (i != 0) {
                            fragment.setSequenceNumber(producer.getIdGenerator().getNextSequence());
                        }
                        fragment.setBodyAsBytes(array[i]);
                        if (this.connection.isUseAsyncSend()) {
                            this.connection.asyncSendPacket(fragment);
                            continue;
                        }
                        this.connection.syncSendPacket(fragment);
                    }
                }
            }
            catch (IOException e) {
                JMSException jmsEx = new JMSException("Failed to fragment message payload");
                jmsEx.setLinkedException((Exception)e);
                throw jmsEx;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending message: " + msg));
        }
        if (!fragmentedMessage) {
            if (this.connection.isUseAsyncSend() || this.acknowledgeMode == 3) {
                this.connection.asyncSendPacket(msg);
            } else {
                this.connection.syncSendPacket(msg);
            }
        }
    }

    protected void doStartTransaction() throws JMSException {
        if (this.getTransacted() && !this.transactionContext.isInXATransaction()) {
            this.transactionContext.begin();
        }
    }

    protected void setSessionConsumerDispatchState(int value) throws JMSException {
        if (this.consumerDispatchState != 1 && value != this.consumerDispatchState) {
            String errorStr = "Cannot mix consumer dispatching on a session - already: ";
            errorStr = value == 3 ? errorStr + "synchronous" : errorStr + "asynchronous";
            throw new IllegalStateException(errorStr);
        }
        this.consumerDispatchState = value;
    }

    protected void redeliverUnacknowledgedMessages() {
        this.redeliverUnacknowledgedMessages(false);
    }

    protected void redeliverUnacknowledgedMessages(boolean onlyDeliverTransientConsumed) {
        this.messageExecutor.stop();
        LinkedList<Object> replay = new LinkedList<Object>();
        Object obj = null;
        while ((obj = this.deliveredMessages.removeFirst()) != null) {
            replay.add(obj);
        }
        this.deliveredMessages.clear();
        if (!replay.isEmpty()) {
            ListIterator i = replay.listIterator(replay.size());
            while (i.hasPrevious()) {
                ActiveMQMessage msg = (ActiveMQMessage)i.previous();
                if (onlyDeliverTransientConsumed && !msg.isTransientConsumed()) continue;
                msg.setJMSRedelivered(true);
                msg.incrementDeliveryCount();
                this.messageExecutor.executeFirst(msg);
            }
        }
        replay.clear();
        this.messageExecutor.start();
    }

    protected void clearMessagesInProgress() {
        this.messageExecutor.clearMessagesInProgress();
        Iterator i = this.consumers.iterator();
        while (i.hasNext()) {
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)i.next();
            consumer.clearMessagesInProgress();
        }
    }

    public boolean hasUncomsumedMessages() {
        return this.messageExecutor.hasUncomsumedMessages();
    }

    public boolean isTransacted() {
        return this.acknowledgeMode == 0;
    }

    protected boolean isClientAcknowledge() {
        return this.acknowledgeMode == 2;
    }

    public boolean isInternalSession() {
        return this.internalSession;
    }

    public void setInternalSession(boolean internalSession) {
        this.internalSession = internalSession;
    }

    private final ActiveMQMessage assembleMessage(ActiveMQMessage message) {
        ActiveMQMessage result = message;
        if (message != null && !this.connection.isInternalConnection() && message.isMessagePart()) {
            if (message.getNumberOfParts() == 1) {
                message.resetMessagePart();
                result = message;
            } else {
                result = null;
                String parentId = message.getParentMessageID();
                ActiveMQMessage[] array = (ActiveMQMessage[])this.assemblies.get(parentId);
                if (array == null) {
                    array = new ActiveMQMessage[message.getNumberOfParts()];
                    this.assemblies.put(parentId, array);
                }
                array[message.getPartNumber()] = message;
                boolean complete = true;
                for (int i = 0; i < array.length; ++i) {
                    complete &= array[i] != null;
                }
                if (complete) {
                    result = array[0];
                    ByteArray[] bas = new ByteArray[array.length];
                    try {
                        for (int i = 0; i < bas.length; ++i) {
                            bas[i] = array[i].getBodyAsBytes();
                            if (i < 1) continue;
                            array[i].clearBody();
                        }
                        ByteArray ba = this.fragmentation.assemble(bas);
                        result.setBodyAsBytes(ba);
                    }
                    catch (IOException ioe) {
                        JMSException jmsEx = new JMSException("Failed to assemble fragment message: " + parentId);
                        jmsEx.setLinkedException((Exception)ioe);
                        this.connection.onException(jmsEx);
                    }
                    catch (JMSException jmsEx) {
                        this.connection.onException(jmsEx);
                    }
                }
            }
        }
        return result;
    }

    public DeliveryListener getDeliveryListener() {
        return this.deliveryListener;
    }

    public void setDeliveryListener(DeliveryListener deliveryListener) {
        this.deliveryListener = deliveryListener;
    }

    public static interface DeliveryListener {
        public void beforeDelivery(ActiveMQSession var1, Message var2);

        public void afterDelivery(ActiveMQSession var1, Message var2);
    }
}

