/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.MessageAck;
import org.activemq.service.MessageIdentity;
import org.activemq.store.MessageStore;
import org.activemq.store.RecoveryListener;
import org.activemq.store.jdbc.JDBCAdapter;
import org.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.activemq.util.JMSExceptionHelper;
import org.activemq.util.LongSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCMessageStore
implements MessageStore {
    private static final Log log = LogFactory.getLog((Class)JDBCMessageStore.class);
    protected final WireFormat wireFormat;
    protected final String destinationName;
    protected final LongSequenceGenerator sequenceGenerator;
    protected final JDBCAdapter adapter;
    protected final JDBCPersistenceAdapter persistenceAdapter;

    public JDBCMessageStore(JDBCPersistenceAdapter persistenceAdapter, JDBCAdapter adapter, WireFormat wireFormat, String destinationName) {
        this.persistenceAdapter = persistenceAdapter;
        this.adapter = adapter;
        this.sequenceGenerator = adapter.getSequenceGenerator();
        this.wireFormat = wireFormat;
        this.destinationName = destinationName;
    }

    public void addMessage(ActiveMQMessage message) throws JMSException {
        byte[] data;
        String messageID = message.getJMSMessageID();
        try {
            data = this.wireFormat.toBytes(message);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to broker message: " + messageID + " in container: " + e, e);
        }
        long seq = this.sequenceGenerator.getNextSequenceId();
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doAddMessage(c, seq, messageID, this.destinationName, data, message.getJMSExpiration());
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to broker message: " + messageID + " in container: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
        MessageIdentity answer = message.getJMSMessageIdentity();
        answer.setSequenceNumber(new Long(seq));
    }

    public ActiveMQMessage getMessage(MessageIdentity identity) throws JMSException {
        long id;
        try {
            id = this.getMessageSequenceId(identity);
        }
        catch (JMSException e1) {
            return null;
        }
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            byte[] data = this.adapter.doGetMessage(c, id);
            if (data == null) {
                ActiveMQMessage activeMQMessage = null;
                return activeMQMessage;
            }
            ActiveMQMessage answer = (ActiveMQMessage)this.wireFormat.fromBytes(data);
            answer.setJMSMessageID(identity.getMessageID());
            answer.setJMSMessageIdentity(identity);
            ActiveMQMessage activeMQMessage = answer;
            return activeMQMessage;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to broker message: " + identity.getMessageID() + " in container: " + e, e);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to broker message: " + identity.getMessageID() + " in container: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    protected long getMessageSequenceId(MessageIdentity identity) throws JMSException {
        Object sequenceNumber = identity.getSequenceNumber();
        if (sequenceNumber != null && sequenceNumber.getClass() == Long.class) {
            return (Long)sequenceNumber;
        }
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            Long rc = this.adapter.getMessageSequenceId(c, identity.getMessageID());
            if (rc == null) {
                throw new JMSException("Could not locate message in database with message id: " + identity.getMessageID());
            }
            long l = rc;
            return l;
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to broker message: " + identity.getMessageID() + " in container: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void removeMessage(MessageAck ack) throws JMSException {
        long seq = this.getMessageSequenceId(ack.getMessageIdentity());
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doRemoveMessage(c, seq);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to broker message: " + ack.getMessageID() + " in container: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void recover(final RecoveryListener listener) throws JMSException {
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doRecover(c, this.destinationName, new JDBCAdapter.MessageListResultHandler(){

                public void onMessage(long seq, String messageID) throws JMSException {
                    listener.recoverMessage(new MessageIdentity(messageID, new Long(seq)));
                }
            });
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to recover container. Reason: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }

    public void start() throws JMSException {
    }

    public void stop() throws JMSException {
    }

    public void removeAllMessages() throws JMSException {
        Connection c = null;
        try {
            c = this.persistenceAdapter.getConnection();
            this.adapter.doRemoveAllMessages(c, this.destinationName);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to broker remove all messages: " + e, e);
        }
        finally {
            this.persistenceAdapter.returnConnection(c);
        }
    }
}

