/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.jms.JMSException;
import javax.sql.DataSource;
import org.activemq.io.WireFormat;
import org.activemq.io.impl.StatelessDefaultWireFormat;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.TransactionStore;
import org.activemq.store.jdbc.JDBCAdapter;
import org.activemq.store.jdbc.JDBCMessageStore;
import org.activemq.store.jdbc.JDBCTopicMessageStore;
import org.activemq.store.jdbc.TransactionContext;
import org.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.activemq.store.vm.VMTransactionStore;
import org.activemq.util.FactoryFinder;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCPersistenceAdapter
implements PersistenceAdapter {
    private static final Log log = LogFactory.getLog((Class)JDBCPersistenceAdapter.class);
    private static FactoryFinder factoryFinder = new FactoryFinder("META-INF/services/org/activemq/store/jdbc/");
    private WireFormat wireFormat = new StatelessDefaultWireFormat();
    private DataSource dataSource;
    private JDBCAdapter adapter;
    private String adapterClass;
    private VMTransactionStore transactionStore;
    private boolean dropTablesOnStartup = false;
    private ClockDaemon clockDaemon;
    private Object clockTicket;

    public JDBCPersistenceAdapter() {
    }

    public JDBCPersistenceAdapter(DataSource ds, WireFormat wireFormat) {
        this.dataSource = ds;
        this.wireFormat = wireFormat;
    }

    public Map getInitialDestinations() {
        return null;
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        if (this.adapter == null) {
            throw new IllegalStateException("Not started");
        }
        MessageStore store = new JDBCMessageStore(this, this.adapter, this.wireFormat.copy(), destinationName);
        if (this.transactionStore != null) {
            store = this.transactionStore.proxy(store);
        }
        return store;
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        if (this.adapter == null) {
            throw new IllegalStateException("Not started");
        }
        TopicMessageStore store = new JDBCTopicMessageStore(this, this.adapter, this.wireFormat.copy(), destinationName);
        if (this.transactionStore != null) {
            store = this.transactionStore.proxy(store);
        }
        return store;
    }

    public TransactionStore createTransactionStore() throws JMSException {
        if (this.adapter == null) {
            throw new IllegalStateException("Not started");
        }
        if (this.transactionStore == null) {
            this.transactionStore = new VMTransactionStore();
        }
        return this.transactionStore;
    }

    public void beginTransaction() throws JMSException {
        try {
            Connection c = this.dataSource.getConnection();
            c.setAutoCommit(false);
            TransactionContext.pushConnection(c);
        }
        catch (SQLException e) {
            throw JMSExceptionHelper.newJMSException("Failed to create transaction: " + e, e);
        }
    }

    public void commitTransaction() throws JMSException {
        Connection c = TransactionContext.popConnection();
        if (c == null) {
            log.warn((Object)"Commit while no transaction in progress");
        } else {
            try {
                c.commit();
            }
            catch (SQLException e) {
                throw JMSExceptionHelper.newJMSException("Failed to commit transaction: " + c + ": " + e, e);
            }
            finally {
                try {
                    c.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() {
        Connection c = TransactionContext.popConnection();
        try {
            c.rollback();
        }
        catch (SQLException e) {
            log.warn((Object)("Cannot rollback transaction due to: " + e), (Throwable)e);
        }
        finally {
            try {
                c.close();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.beginTransaction();
        Connection c = null;
        try {
            this.adapter = null;
            try {
                c = this.getConnection();
            }
            catch (SQLException e) {
                throw JMSExceptionHelper.newJMSException("Could not get a database connection: " + e, e);
            }
            if (this.adapterClass == null) {
                try {
                    String dirverName = c.getMetaData().getDriverName();
                    dirverName = dirverName.replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase();
                    try {
                        this.adapter = (DefaultJDBCAdapter)factoryFinder.newInstance(dirverName);
                        log.info((Object)("Database driver recognized: [" + dirverName + "]"));
                    }
                    catch (Throwable e) {
                        log.warn((Object)("Database driver NOT recognized: [" + dirverName + "].  Will use default JDBC implementation."));
                    }
                }
                catch (SQLException e) {
                    log.warn((Object)("JDBC error occured while trying to detect database type.  Will use default JDBC implementation: " + e.getMessage()));
                    log.debug((Object)("Reason: " + e), (Throwable)e);
                }
            } else {
                try {
                    Class<?> clazz = JDBCPersistenceAdapter.class.getClassLoader().loadClass(this.adapterClass);
                    this.adapter = (DefaultJDBCAdapter)clazz.newInstance();
                }
                catch (Throwable e) {
                    log.warn((Object)("Invalid JDBC adapter class class (" + this.adapterClass + ").  Will use default JDBC implementation."));
                    log.debug((Object)("Reason: " + e), e);
                }
            }
            if (this.adapter == null) {
                this.adapter = new DefaultJDBCAdapter();
            }
            if (this.dropTablesOnStartup) {
                try {
                    this.adapter.doDropTables(c);
                }
                catch (SQLException e) {
                    log.warn((Object)("Cannot drop tables due to: " + e), (Throwable)e);
                }
            }
            try {
                this.adapter.doCreateTables(c);
            }
            catch (SQLException e) {
                log.warn((Object)("Cannot create tables due to: " + e), (Throwable)e);
            }
            this.adapter.initSequenceGenerator(c);
        }
        finally {
            this.commitTransaction();
        }
        this.clockTicket = this.getClockDaemon().executePeriodically(300000L, new Runnable(){

            public void run() {
                JDBCPersistenceAdapter.this.cleanup();
            }
        }, false);
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void cleanup() {
        Connection c = null;
        try {
            log.debug((Object)"Cleaning up old messages.");
            c = this.getConnection();
            this.adapter.doDeleteOldMessages(c);
            this.returnConnection(c);
        }
        catch (JMSException e) {
            log.warn((Object)("Old message cleanup failed due to: " + (Object)((Object)e)), (Throwable)e);
            this.returnConnection(c);
            log.debug((Object)"Cleanup done.");
        }
        catch (SQLException e2) {
            log.warn((Object)("Old message cleanup failed due to: " + e2), (Throwable)e2);
            this.returnConnection(c);
            {
                catch (Throwable throwable) {
                    this.returnConnection(c);
                    log.debug((Object)"Cleanup done.");
                    throw throwable;
                }
            }
            log.debug((Object)"Cleanup done.");
        }
        log.debug((Object)"Cleanup done.");
    }

    public void setClockDaemon(ClockDaemon clockDaemon) {
        this.clockDaemon = clockDaemon;
    }

    public ClockDaemon getClockDaemon() {
        if (this.clockDaemon == null) {
            this.clockDaemon = new ClockDaemon();
            this.clockDaemon.setThreadFactory(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "Cleanup Timmer");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return this.clockDaemon;
    }

    public synchronized void stop() throws JMSException {
        if (this.clockTicket != null) {
            ClockDaemon.cancel((Object)this.clockTicket);
            this.clockTicket = null;
            this.clockDaemon.shutDown();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public Connection getConnection() throws SQLException {
        Connection answer = TransactionContext.peekConnection();
        if (answer == null) {
            answer = this.dataSource.getConnection();
            answer.setAutoCommit(true);
        }
        return answer;
    }

    public void returnConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        Connection peek = TransactionContext.peekConnection();
        if (peek != connection) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String getAdapterClass() {
        return this.adapterClass;
    }

    public void setAdapterClass(String adapterClass) {
        this.adapterClass = adapterClass;
    }

    public boolean getDropTablesOnStartup() {
        return this.dropTablesOnStartup;
    }

    public void setDropTablesOnStartup(boolean dropTablesOnStartup) {
        this.dropTablesOnStartup = dropTablesOnStartup;
    }
}

