/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.multicast;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.MulticastSocket;
import java.net.URI;
import javax.jms.JMSException;
import org.activemq.io.WireFormat;
import org.activemq.transport.udp.UdpTransportChannel;

public class MulticastTransportChannel
extends UdpTransportChannel {
    private boolean loopbackMode = false;
    private int timeToLive = 1;

    public MulticastTransportChannel(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        super(wireFormat, remoteLocation);
    }

    public MulticastTransportChannel(WireFormat wireFormat, MulticastSocket socket) throws JMSException {
        super(wireFormat, socket);
    }

    public boolean isMulticast() {
        return true;
    }

    public String toString() {
        return "MulticastTransportChannel: " + this.socket;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) throws IOException {
        this.timeToLive = timeToLive;
        MulticastSocket msocket = (MulticastSocket)this.socket;
        if (msocket != null) {
            msocket.setTimeToLive(timeToLive);
        }
    }

    protected void connect() throws IOException {
        MulticastSocket msocket = (MulticastSocket)this.socket;
        msocket.setLoopbackMode(this.loopbackMode);
        msocket.setTimeToLive(this.getTimeToLive());
        msocket.joinGroup(this.inetAddress);
    }

    protected DatagramSocket createSocket(int port) throws IOException {
        return new MulticastSocket(port);
    }
}

