/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.activemq.filter.XPathExpression;
import org.apache.xmlbeans.XmlObject;

public class XMLBeansXPathEvaluator
implements XPathExpression.XPathEvaluator {
    private final String xpath;

    public XMLBeansXPathEvaluator(String xpath) {
        this.xpath = xpath;
    }

    public boolean evaluate(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            String text = ((TextMessage)message).getText();
            try {
                XmlObject object = XmlObject.Factory.parse((String)text);
                XmlObject[] objects = object.selectPath(this.xpath);
                return object != null && objects.length > 0;
            }
            catch (Throwable e) {
                return false;
            }
        }
        if (message instanceof BytesMessage) {
            BytesMessage bm = (BytesMessage)message;
            byte[] data = new byte[(int)bm.getBodyLength()];
            bm.readBytes(data);
            try {
                XmlObject object = XmlObject.Factory.parse((InputStream)new ByteArrayInputStream(data));
                XmlObject[] objects = object.selectPath(this.xpath);
                return object != null && objects.length > 0;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return false;
    }
}

