/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.util.ArrayList;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQSession;
import org.activemq.LocalTransactionEventListener;
import org.activemq.message.ActiveMQXid;
import org.activemq.message.IntResponseReceipt;
import org.activemq.message.ResponseReceipt;
import org.activemq.message.TransactionInfo;
import org.activemq.message.XATransactionInfo;
import org.activemq.util.IdGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionContext
implements XAResource {
    private static final Log log = LogFactory.getLog((Class)TransactionContext.class);
    private final ActiveMQConnection connection;
    private final ArrayList sessions = new ArrayList(2);
    private final IdGenerator localTransactionIdGenerator = new IdGenerator();
    private Xid associatedXid;
    private ActiveMQXid activeXid;
    private String localTransactionId;
    private LocalTransactionEventListener localTransactionEventListener;

    public TransactionContext(ActiveMQConnection connection) {
        this.connection = connection;
    }

    public boolean isInXATransaction() {
        return this.associatedXid != null;
    }

    public boolean isInLocalTransaction() {
        return this.localTransactionId != null;
    }

    public LocalTransactionEventListener getLocalTransactionEventListener() {
        return this.localTransactionEventListener;
    }

    public void setLocalTransactionEventListener(LocalTransactionEventListener localTransactionEventListener) {
        this.localTransactionEventListener = localTransactionEventListener;
    }

    public void addSession(ActiveMQSession session) {
        this.sessions.add(session);
    }

    public void removeSession(ActiveMQSession session) {
        this.sessions.remove(session);
    }

    private void postRollback() {
        int size = this.sessions.size();
        for (int i = 0; i < size; ++i) {
            ((ActiveMQSession)this.sessions.get(i)).redeliverUnacknowledgedMessages(true);
        }
    }

    private void postCommit() {
        int size = this.sessions.size();
        for (int i = 0; i < size; ++i) {
            ((ActiveMQSession)this.sessions.get(i)).clearDeliveredMessages();
        }
    }

    public Object getTransactionId() {
        if (this.localTransactionId != null) {
            return this.localTransactionId;
        }
        return this.activeXid;
    }

    public void begin() throws JMSException {
        if (this.associatedXid != null) {
            throw new TransactionInProgressException("Cannot start local transction.  XA transaction is allready in progress.");
        }
        if (this.localTransactionId == null) {
            this.localTransactionId = this.localTransactionIdGenerator.generateId();
            TransactionInfo info = new TransactionInfo();
            info.setTransactionId(this.localTransactionId);
            info.setType(101);
            this.connection.asyncSendPacket(info);
            if (this.localTransactionEventListener != null) {
                this.localTransactionEventListener.beginEvent();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Started local transaction: " + this.localTransactionId));
            }
        }
    }

    public void rollback() throws JMSException {
        if (this.associatedXid != null) {
            throw new TransactionInProgressException("Cannot rollback() if an XA transaction is allready in progress ");
        }
        if (this.localTransactionId != null) {
            TransactionInfo info = new TransactionInfo();
            info.setTransactionId(this.localTransactionId);
            info.setType(105);
            this.localTransactionId = null;
            this.connection.asyncSendPacket(info);
            if (this.localTransactionEventListener != null) {
                this.localTransactionEventListener.rollbackEvent();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rolledback local transaction: " + this.localTransactionId));
            }
        }
        this.postRollback();
    }

    public void commit() throws JMSException {
        if (this.associatedXid != null) {
            throw new TransactionInProgressException("Cannot commit() if an XA transaction is allready in progress ");
        }
        if (this.localTransactionId != null) {
            TransactionInfo info = new TransactionInfo();
            info.setTransactionId(this.localTransactionId);
            info.setType(103);
            this.localTransactionId = null;
            this.connection.syncSendPacket(info);
            if (this.localTransactionEventListener != null) {
                this.localTransactionEventListener.commitEvent();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committed local transaction: " + this.localTransactionId));
            }
        }
        this.postCommit();
    }

    public void start(Xid xid, int flags) throws XAException {
        if (this.localTransactionId != null) {
            throw new XAException(-6);
        }
        if (this.associatedXid != null) {
            throw new XAException(-6);
        }
        if ((flags & 0x200000) == 0x200000) {
            // empty if block
        }
        if ((flags & 0x200000) == 0x8000000) {
            // empty if block
        }
        this.setXid(xid);
    }

    public void end(Xid xid, int flags) throws XAException {
        if (this.localTransactionId != null) {
            throw new XAException(-6);
        }
        if ((flags & 0x2000000) == 0x2000000) {
            if (this.associatedXid == null || !ActiveMQXid.equals(this.associatedXid, xid)) {
                throw new XAException(-6);
            }
            this.setXid(null);
        } else if ((flags & 0x20000000) == 0x20000000) {
            this.setXid(null);
        } else if ((flags & 0x4000000) == 0x4000000) {
            if (ActiveMQXid.equals(this.associatedXid, xid)) {
                this.setXid(null);
            }
        } else {
            throw new XAException(-5);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ended XA transaction: " + this.activeXid));
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (ActiveMQXid.equals(this.associatedXid, xid)) {
            throw new XAException(-6);
        }
        ActiveMQXid x = new ActiveMQXid(xid);
        XATransactionInfo info = new XATransactionInfo();
        info.setXid(x);
        info.setType(102);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Preparing XA transaction: " + x));
            }
            IntResponseReceipt receipt = (IntResponseReceipt)this.connection.syncSendRequest(info);
            return receipt.getResult();
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public void rollback(Xid xid) throws XAException {
        ActiveMQXid x = ActiveMQXid.equals(this.associatedXid, xid) ? this.activeXid : new ActiveMQXid(xid);
        XATransactionInfo info = new XATransactionInfo();
        info.setXid(x);
        info.setType(105);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rollingback XA transaction: " + x));
            }
            this.connection.syncSendPacket(info);
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
        this.postRollback();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (ActiveMQXid.equals(this.associatedXid, xid)) {
            throw new XAException(-6);
        }
        ActiveMQXid x = new ActiveMQXid(xid);
        XATransactionInfo info = new XATransactionInfo();
        info.setXid(x);
        info.setType(onePhase ? 109 : 103);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing XA transaction: " + x));
            }
            this.connection.syncSendPacket(info);
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
        this.postCommit();
    }

    public void forget(Xid xid) throws XAException {
        ActiveMQXid x = ActiveMQXid.equals(this.associatedXid, xid) ? this.activeXid : new ActiveMQXid(xid);
        XATransactionInfo info = new XATransactionInfo();
        info.setXid(x);
        info.setType(107);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Forgetting XA transaction: " + x));
            }
            this.connection.syncSendPacket(info);
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource == null) {
            return false;
        }
        if (!(xaResource instanceof TransactionContext)) {
            return false;
        }
        TransactionContext xar = (TransactionContext)xaResource;
        try {
            return this.getResourceManagerId().equals(xar.getResourceManagerId());
        }
        catch (Throwable e) {
            throw (XAException)new XAException("Could not get resource manager id.").initCause(e);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        XATransactionInfo info = new XATransactionInfo();
        info.setType(110);
        try {
            ResponseReceipt receipt = (ResponseReceipt)this.connection.syncSendRequest(info);
            return (ActiveMQXid[])receipt.getResult();
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public int getTransactionTimeout() throws XAException {
        XATransactionInfo info = new XATransactionInfo();
        info.setType(111);
        try {
            IntResponseReceipt receipt = (IntResponseReceipt)this.connection.syncSendRequest(info);
            return receipt.getResult();
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        XATransactionInfo info = new XATransactionInfo();
        info.setType(112);
        info.setTransactionTimeout(seconds);
        try {
            this.connection.asyncSendPacket(info);
            return true;
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    private String getResourceManagerId() throws JMSException {
        return this.connection.getResourceManagerId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setXid(Xid xid) throws XAException {
        if (xid != null) {
            this.associatedXid = xid;
            this.activeXid = new ActiveMQXid(xid);
            XATransactionInfo info = new XATransactionInfo();
            info.setXid(this.activeXid);
            info.setType(101);
            try {
                this.connection.asyncSendPacket(info);
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Started XA transaction: " + this.activeXid));
                return;
            }
            catch (JMSException e) {
                throw this.toXAException(e);
            }
        }
        if (this.activeXid != null) {
            XATransactionInfo info = new XATransactionInfo();
            info.setXid(this.activeXid);
            info.setType(106);
            try {
                this.connection.syncSendPacket(info);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Ended XA transaction: " + this.activeXid));
                }
            }
            catch (JMSException e) {
                throw this.toXAException(e);
            }
        }
        this.associatedXid = null;
        this.activeXid = null;
    }

    private XAException toXAException(JMSException e) {
        if (e.getCause() != null && e.getCause() instanceof XAException) {
            XAException original = (XAException)e.getCause();
            XAException xae = new XAException(original.getMessage());
            xae.errorCode = original.errorCode;
            xae.initCause(original);
            return xae;
        }
        XAException xae = new XAException(e.getMessage());
        xae.errorCode = -7;
        xae.initCause(e);
        return xae;
    }

    public ActiveMQConnection getConnection() {
        return this.connection;
    }
}

