/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.activeio;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import javax.jms.JMSException;
import org.activeio.AcceptListener;
import org.activeio.AsynchChannel;
import org.activeio.AsynchChannelServer;
import org.activeio.Channel;
import org.activeio.adapter.SynchToAsynchChannelAdapter;
import org.activemq.io.WireFormat;
import org.activemq.transport.TransportServerChannelSupport;
import org.activemq.transport.activeio.ActiveIOTransportChannel;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveIOTransportServerChannel
extends TransportServerChannelSupport
implements AcceptListener {
    private static final Log log = LogFactory.getLog((Class)ActiveIOTransportServerChannel.class);
    private final WireFormat wireFormat;
    private final AsynchChannelServer server;
    private final SynchronizedBoolean closed = new SynchronizedBoolean(false);

    public ActiveIOTransportServerChannel(WireFormat wireFormat, AsynchChannelServer server) {
        super(server.getBindURI());
        this.wireFormat = wireFormat;
        this.server = server;
        server.setAcceptListener((AcceptListener)this);
    }

    public void start() throws JMSException {
        try {
            super.start();
            this.server.start();
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException(e.getMessage(), e);
        }
    }

    public void stop() throws JMSException {
        if (this.closed.commit(false, true)) {
            super.stop();
            this.server.dispose();
        }
    }

    public String toString() {
        return "ActiveIOTransportServerChannel@" + this.getUrl();
    }

    public void onAccept(Channel c) {
        if (this.closed.get()) {
            c.dispose();
            return;
        }
        AsynchChannel channel = SynchToAsynchChannelAdapter.adapt((Channel)c);
        this.addClient(new ActiveIOTransportChannel(this.wireFormat.copy(), channel));
    }

    public void onAcceptError(IOException error) {
        if (!this.closed.get()) {
            log.warn((Object)("Caught exception accepting connection: " + error), (Throwable)error);
            try {
                this.stop();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

