/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.activemq.filter.XPathExpression;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;

public class XalanXPathEvaluator
implements XPathExpression.XPathEvaluator {
    private final String xpath;

    public XalanXPathEvaluator(String xpath) {
        this.xpath = xpath;
    }

    public boolean evaluate(Message message) throws JMSException {
        if (message instanceof TextMessage) {
            String text = ((TextMessage)message).getText();
            return this.evaluate(text);
        }
        if (message instanceof BytesMessage) {
            BytesMessage bm = (BytesMessage)message;
            byte[] data = new byte[(int)bm.getBodyLength()];
            bm.readBytes(data);
            return this.evaluate(data);
        }
        return false;
    }

    private boolean evaluate(byte[] data) {
        try {
            InputSource inputSource = new InputSource(new ByteArrayInputStream(data));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder dbuilder = factory.newDocumentBuilder();
            Document doc = dbuilder.parse(inputSource);
            CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
            NodeIterator iterator = cachedXPathAPI.selectNodeIterator((Node)doc, this.xpath);
            return iterator.nextNode() != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean evaluate(String text) {
        try {
            InputSource inputSource = new InputSource(new StringReader(text));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder dbuilder = factory.newDocumentBuilder();
            Document doc = dbuilder.parse(inputSource);
            CachedXPathAPI cachedXPathAPI = new CachedXPathAPI();
            NodeIterator iterator = cachedXPathAPI.selectNodeIterator((Node)doc, this.xpath);
            return iterator.nextNode() != null;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

