/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import org.activemq.service.QueueList;
import org.activemq.service.QueueListEntry;
import org.activemq.util.FastInputStream;
import org.activemq.util.FastOutputStream;
import org.activemq.util.JMSExceptionHelper;

public abstract class QueueListSupport
implements QueueList {
    protected static final Long HEAD_KEY = new Long(0L);

    public Object getFirst() throws JMSException {
        try {
            Node node;
            Long key = this.getHeader().headKey;
            if (key != null && (node = this.getNode(key)) != null) {
                return node.getElement();
            }
            return null;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public Object getLast() throws JMSException {
        try {
            Node node;
            Long key = this.getHeader().tailKey;
            if (key != null && (node = this.getNode(key)) != null) {
                return node.getElement();
            }
            return null;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public Object removeFirst() throws JMSException {
        try {
            Node node;
            Header header = this.getHeader();
            Long key = header.headKey;
            if (key != null && (node = this.getNode(key)) != null) {
                this.doRemoveNode(node);
                header.headKey = node.nextKey;
                --header.size;
                this.updateHeader(header);
                return node.getElement();
            }
            return null;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
        }
    }

    public Object removeLast() throws JMSException {
        try {
            Node node;
            Header header = this.getHeader();
            Long key = header.tailKey;
            if (key != null && (node = this.getNode(key)) != null) {
                this.doRemoveNode(node);
                header.tailKey = node.previousKey;
                --header.size;
                this.updateHeader(header);
                return node.getElement();
            }
            return null;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
        }
    }

    public QueueListEntry addFirst(Object value) throws JMSException {
        try {
            Long key;
            Long nextKey;
            Header header = this.getHeader();
            Node node = this.createNode();
            node.value = value;
            node.nextKey = nextKey = header.headKey;
            node.key = key = this.createKey(header);
            this.updateNode(node);
            this.updateNextNode(nextKey, key);
            header.headKey = key;
            if (header.tailKey == null) {
                header.tailKey = key;
            }
            ++header.size;
            this.updateHeader(header);
            return node;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
        }
    }

    public QueueListEntry addLast(Object value) throws JMSException {
        try {
            Header header = this.getHeader();
            return this.doAddLast(value, header);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
        }
    }

    public boolean contains(Object value) throws JMSException {
        return this.indexOf(value) != -1;
    }

    public int size() throws JMSException {
        try {
            return this.getHeader().size;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public boolean isEmpty() throws JMSException {
        int size = this.size();
        return size == 0;
    }

    public QueueListEntry add(Object value) throws JMSException {
        return this.addLast(value);
    }

    public Object get(int index) throws JMSException {
        try {
            Node node = this.getNode(index);
            if (node != null) {
                return node.value;
            }
            return null;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public Object set(int index, Object element) throws JMSException {
        try {
            Node node = this.getNode(index);
            if (node != null) {
                Object previous = node.value;
                node.value = element;
                this.updateNode(node);
                return previous;
            }
            return null;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
        }
    }

    public void add(int index, Object element) throws JMSException {
        if (index == 0) {
            this.addFirst(element);
        } else {
            try {
                Header header = this.getHeader();
                Node nextNode = this.getNode(header, index);
                this.doAddBefore(header, nextNode, element);
            }
            catch (IOException e) {
                throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
            }
        }
    }

    public Object remove(int index) throws JMSException {
        try {
            Node node = this.getNode(index);
            if (node != null) {
                this.removeNode(node);
            }
            return null;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
        }
    }

    public int indexOf(Object value) throws JMSException {
        try {
            Node node;
            Header header = this.getHeader();
            Long key = header.headKey;
            int i = 0;
            while (key != null && (node = this.getNode(key)) != null) {
                if (value == node.value || value != null && value.equals(node.value)) {
                    return i;
                }
                key = node.nextKey;
                ++i;
            }
            return -1;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public int lastIndexOf(Object value) throws JMSException {
        try {
            Node node;
            Header header = this.getHeader();
            Long key = header.tailKey;
            int i = header.size - 1;
            while (key != null && (node = this.getNode(key)) != null) {
                if (value == node.value || value != null && value.equals(node.value)) {
                    return i;
                }
                key = node.previousKey;
                --i;
            }
            return -1;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public QueueListEntry getFirstEntry() throws JMSException {
        try {
            return this.getNode(this.getHeader().headKey);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public QueueListEntry getLastEntry() throws JMSException {
        try {
            return this.getNode(this.getHeader().tailKey);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public QueueListEntry getNextEntry(QueueListEntry entry) throws JMSException {
        Node node = (Node)entry;
        try {
            return this.getNode(node.nextKey);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public QueueListEntry getPrevEntry(QueueListEntry entry) throws JMSException {
        Node node = (Node)entry;
        try {
            return this.getNode(node.previousKey);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to read from table: " + e, e);
        }
    }

    public QueueListEntry addBefore(Object value, QueueListEntry entry) throws JMSException {
        try {
            return this.doAddBefore(this.getHeader(), (Node)entry, value);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
        }
    }

    public void remove(QueueListEntry entry) throws JMSException {
        try {
            this.removeNode((Node)entry);
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
        }
    }

    public Object[] toArray() throws JMSException {
        try {
            Header header = this.getHeader();
            int size = header.size;
            if (size == 0) {
                return EMPTY_ARRAY;
            }
            Long key = header.headKey;
            Object[] answer = new Object[size];
            for (int i = 0; i < size && key != null; ++i) {
                Node node = this.getNode(key);
                if (node == null) continue;
                answer[i] = node.value;
                key = node.nextKey;
            }
            return answer;
        }
        catch (IOException e) {
            throw JMSExceptionHelper.newJMSException("Failed to write to table: " + e, e);
        }
    }

    public void rotate() throws JMSException {
        Object obj = this.removeFirst();
        if (obj != null) {
            this.addLast(obj);
        }
    }

    protected Long createKey(Header header) throws IOException, JMSException {
        Long key;
        long value = header.lastKeyValue;
        do {
            if (value == Long.MAX_VALUE) {
                value = 1L;
                continue;
            }
            ++value;
        } while (this.getNode(key = new Long(value)) != null);
        header.lastKeyValue = value;
        return key;
    }

    protected boolean removeNode(Node node) throws IOException, JMSException {
        Node nextNode;
        Node previousNode;
        Header header = null;
        boolean updatedPrevious = false;
        if (node.previousKey != null && (previousNode = this.getNode(node.previousKey)) != null) {
            previousNode.nextKey = node.nextKey;
            this.updateNode(previousNode);
            updatedPrevious = true;
        }
        if (!updatedPrevious) {
            header = this.getHeader();
            header.headKey = node.nextKey;
        }
        boolean updatedNext = false;
        if (node.nextKey != null && (nextNode = this.getNode(node.nextKey)) != null) {
            nextNode.previousKey = node.previousKey;
            this.updateNode(nextNode);
            updatedNext = true;
        }
        if (!updatedNext) {
            header = this.getHeader();
            header.tailKey = node.previousKey;
        }
        return true;
    }

    protected abstract Header getHeader() throws IOException, JMSException;

    protected abstract void updateHeader(Header var1) throws IOException, JMSException;

    protected abstract void updateNode(Node var1) throws IOException, JMSException;

    protected abstract Node getNode(Long var1) throws IOException, JMSException;

    protected Node getNode(int index) throws IOException, JMSException {
        Header header = this.getHeader();
        return this.getNode(header, index);
    }

    protected Node getNode(Header header, int index) throws IOException, JMSException {
        Node node = null;
        int middle = header.size / 2;
        if (index > middle) {
            Long key = header.tailKey;
            for (int i = header.size; i > index && key != null; --i) {
                node = this.getNode(key);
                if (node == null) continue;
                key = node.previousKey;
            }
        } else {
            Long key = header.headKey;
            for (int i = 0; i <= index && key != null; ++i) {
                node = this.getNode(key);
                if (node == null) continue;
                key = node.nextKey;
            }
        }
        return node;
    }

    protected Node doAddLast(Object value, Header header) throws IOException, JMSException {
        Long previousKey;
        Long key;
        Node node = this.createNode();
        node.key = key = this.createKey(header);
        node.value = value;
        node.previousKey = previousKey = header.tailKey;
        this.updateNode(node);
        this.updatePreviousNode(previousKey, key);
        header.tailKey = key;
        if (header.headKey == null) {
            header.headKey = key;
        }
        ++header.size;
        this.updateHeader(header);
        return node;
    }

    protected void updateNextNode(Long nextKey, Long key) throws IOException, JMSException {
        if (nextKey != null) {
            Node nextNode = this.getNode(nextKey);
            if (nextNode == null) {
                throw new IOException("Missing node for key: " + nextKey);
            }
            nextNode.previousKey = key;
            this.updateNode(nextNode);
        }
    }

    protected void updatePreviousNode(Long previousKey, Long key) throws IOException, JMSException {
        if (previousKey != null) {
            Node previousNode = this.getNode(previousKey);
            if (previousNode == null) {
                throw new IOException("Missing previous node for key: " + previousKey);
            }
            previousNode.nextKey = key;
            this.updateNode(previousNode);
        }
    }

    protected Node doAddBefore(Header header, Node nextNode, Object element) throws JMSException, IOException {
        Long previousKey;
        if (nextNode == null) {
            return this.doAddLast(element, header);
        }
        Long key = this.createKey(header);
        Node node = this.createNode();
        node.value = element;
        node.key = key;
        node.previousKey = previousKey = nextNode.previousKey;
        node.nextKey = nextNode.key;
        nextNode.previousKey = key;
        ++header.size;
        this.updateNode(node);
        this.updateNode(nextNode);
        this.updatePreviousNode(previousKey, key);
        this.updateHeader(header);
        return node;
    }

    protected abstract void doRemoveNode(Node var1) throws IOException, JMSException;

    protected static Long wrapLong(long value) {
        if (value == 0L) {
            return null;
        }
        return new Long(value);
    }

    protected static long unwrapLong(Long key) {
        if (key != null) {
            return key;
        }
        return 0L;
    }

    protected Node createNode() {
        return new Node();
    }

    public static class Node
    implements Serializable,
    QueueListEntry {
        private static final long serialVersionUID = 4609474001468609536L;
        public Long previousKey;
        public Long nextKey;
        public Object value;
        public transient Long key;

        public Object getElement() {
            return this.value;
        }

        public byte[] asBytes() throws IOException {
            FastOutputStream buffer = new FastOutputStream();
            DataOutputStream out = new DataOutputStream(buffer);
            out.writeLong(QueueListSupport.unwrapLong(this.previousKey));
            out.writeLong(QueueListSupport.unwrapLong(this.nextKey));
            out.writeUTF((String)this.value);
            return buffer.toByteArray();
        }

        public void fromBytes(byte[] data) throws IOException {
            DataInputStream in = new DataInputStream(new FastInputStream(data));
            this.previousKey = QueueListSupport.wrapLong(in.readLong());
            this.nextKey = QueueListSupport.wrapLong(in.readLong());
            this.value = in.readUTF();
        }
    }

    public static class Header
    implements Serializable {
        private static final long serialVersionUID = 64734383295040L;
        public Long headKey;
        public Long tailKey;
        public long lastKeyValue;
        public int size;

        public byte[] asBytes() throws IOException {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(buffer);
            out.writeLong(QueueListSupport.unwrapLong(this.headKey));
            out.writeLong(QueueListSupport.unwrapLong(this.tailKey));
            out.writeLong(this.lastKeyValue);
            out.writeInt(this.size);
            return buffer.toByteArray();
        }

        public void fromBytes(byte[] data) throws IOException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            this.headKey = QueueListSupport.wrapLong(in.readLong());
            this.tailKey = QueueListSupport.wrapLong(in.readLong());
            this.lastKeyValue = in.readLong();
            this.size = in.readInt();
        }
    }
}

