/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Properties;
import org.activemq.message.TransactionInfo;
import org.activemq.transport.stomp.Command;
import org.activemq.transport.stomp.HeaderParser;
import org.activemq.transport.stomp.PacketEnvelope;
import org.activemq.transport.stomp.StompWireFormat;

class Commit
implements Command {
    private StompWireFormat format;
    private static final HeaderParser parser = new HeaderParser();

    Commit(StompWireFormat format) {
        this.format = format;
    }

    public PacketEnvelope build(String commandLine, DataInput in) throws IOException {
        Properties headers = parser.parse(in);
        while (in.readByte() != 0) {
        }
        if (!this.format.isInTransaction()) {
            throw new ProtocolException("Cannot COMMIT when not in a transaction");
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setTransactionId(this.format.getTransactionId());
        tx.setType(103);
        this.format.clearTransactionId();
        return new PacketEnvelope(tx, headers);
    }
}

