/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.util.Properties;
import javax.jms.JMSException;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.transport.stomp.Command;
import org.activemq.transport.stomp.DestinationNamer;
import org.activemq.transport.stomp.HeaderParser;
import org.activemq.transport.stomp.PacketEnvelope;
import org.activemq.transport.stomp.StompWireFormat;

class Send
implements Command {
    private final HeaderParser parser = new HeaderParser();
    private final StompWireFormat format;

    Send(StompWireFormat format) {
        this.format = format;
    }

    public PacketEnvelope build(String commandLine, DataInput in) throws IOException {
        byte b;
        Properties headers = this.parser.parse(in);
        String destination = headers.getProperty("destination");
        ActiveMQTextMessage text = new ActiveMQTextMessage();
        text.setJMSMessageID(StompWireFormat.PACKET_IDS.generateId());
        ActiveMQDestination d = DestinationNamer.convert(destination);
        text.setJMSDestination(d);
        text.setJMSClientID(this.format.getClientId());
        if (this.format.isInTransaction()) {
            text.setTransactionIDString(this.format.getTransactionId());
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        while ((b = in.readByte()) != 0) {
            bytes.write(b);
        }
        bytes.close();
        String body = new String(bytes.toByteArray());
        try {
            text.setText(body);
        }
        catch (JMSException e) {
            throw new RuntimeException("Something is really wrong, we instantiated this thing!");
        }
        return new PacketEnvelope(text, headers);
    }
}

