/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataOutput;
import java.io.IOException;
import javax.jms.JMSException;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.MessageAck;
import org.activemq.transport.stomp.DestinationNamer;
import org.activemq.transport.stomp.FrameBuilder;
import org.activemq.transport.stomp.StompWireFormat;

class Subscription {
    private ActiveMQDestination destination;
    private int ackMode = 1;
    private StompWireFormat format;
    private short consumer_no;
    private final String consumerId;
    static final int AUTO_ACK = 1;
    static final int CLIENT_ACK = 2;

    Subscription(StompWireFormat format, short consumer_no, String consumerId) {
        this.format = format;
        this.consumer_no = consumer_no;
        this.consumerId = consumerId;
    }

    void setDestination(ActiveMQDestination actual_dest) {
        this.destination = actual_dest;
    }

    void receive(ActiveMQTextMessage msg, DataOutput out) throws IOException, JMSException {
        if (this.ackMode == 2) {
            throw new UnsupportedOperationException("Client Acks not yet supported");
        }
        if (this.ackMode == 1) {
            MessageAck ack = new MessageAck();
            if (this.format.isInTransaction()) {
                ack.setTransactionIDString(this.format.getTransactionId());
            }
            ack.setDestination(msg.getJMSActiveMQDestination());
            ack.setConsumerId(this.consumerId);
            ack.setMessageID(msg.getJMSMessageID());
            ack.setMessageRead(true);
            ack.setSessionId(this.format.getSessionId());
            ack.setProducerKey(msg.getProducerKey());
            ack.setSequenceNumber(msg.getSequenceNumber());
            ack.setPersistent(msg.getJMSDeliveryMode() == 2);
            this.format.enqueuePacket(ack);
        }
        out.writeBytes(new FrameBuilder("MESSAGE").addHeader("destination", DestinationNamer.convert(msg.getJMSActiveMQDestination())).setBody(msg.getText()).toFrame());
    }

    ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setAckMode(int clientAck) {
        this.ackMode = clientAck;
    }

    public ConsumerInfo close() {
        ConsumerInfo unsub = new ConsumerInfo();
        unsub.setStarted(false);
        unsub.setDestination(this.destination);
        unsub.setClientId(this.format.getClientId());
        unsub.setConsumerNo(this.consumer_no);
        return unsub;
    }
}

