/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.util;

import java.io.IOException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMSExceptionHelper {
    private static final Log log = LogFactory.getLog((Class)JMSExceptionHelper.class);

    public static JMSException newJMSException(String message, Throwable cause) {
        if (cause instanceof Exception) {
            return JMSExceptionHelper.newJMSException(message, (Exception)cause);
        }
        return JMSExceptionHelper.newJMSException(message, new Exception(cause));
    }

    public static JMSException newJMSException(String message, Exception cause) {
        log.trace((Object)message, (Throwable)cause);
        JMSException jmsEx = new JMSException(message);
        jmsEx.setLinkedException(cause);
        jmsEx.initCause((Throwable)cause);
        return jmsEx;
    }

    public static JMSException newJMSException(Throwable e) {
        if (e instanceof JMSException) {
            return (JMSException)e;
        }
        return JMSExceptionHelper.newJMSException(e.getMessage(), e);
    }

    public static IOException newIOException(JMSException e) {
        IOException answer = new IOException(e.getMessage());
        answer.setStackTrace(e.getStackTrace());
        return answer;
    }
}

