/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArrayList;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import org.activemq.ActiveMQConnectionConsumer;
import org.activemq.ActiveMQConnectionFactory;
import org.activemq.ActiveMQConnectionMetaData;
import org.activemq.ActiveMQMessageConsumer;
import org.activemq.ActiveMQMessageDispatcher;
import org.activemq.ActiveMQMessageProducer;
import org.activemq.ActiveMQMessageTransformation;
import org.activemq.ActiveMQPrefetchPolicy;
import org.activemq.ActiveMQQueueSession;
import org.activemq.ActiveMQSession;
import org.activemq.ActiveMQTopicSession;
import org.activemq.Closeable;
import org.activemq.ConnectionClosedException;
import org.activemq.TimeoutExpiredException;
import org.activemq.advisories.TempDestinationAdvisor;
import org.activemq.advisories.TempDestinationAdvisoryEvent;
import org.activemq.capacity.CapacityMonitorEvent;
import org.activemq.capacity.CapacityMonitorEventListener;
import org.activemq.filter.AndFilter;
import org.activemq.filter.Filter;
import org.activemq.filter.FilterFactory;
import org.activemq.filter.FilterFactoryImpl;
import org.activemq.filter.NoLocalFilter;
import org.activemq.io.util.ByteArray;
import org.activemq.io.util.ByteArrayFragmentation;
import org.activemq.io.util.MemoryBoundedObjectManager;
import org.activemq.io.util.MemoryBoundedQueue;
import org.activemq.io.util.MemoryBoundedQueueManager;
import org.activemq.management.JMSConnectionStatsImpl;
import org.activemq.management.JMSStatsImpl;
import org.activemq.management.StatsCapable;
import org.activemq.management.StatsImpl;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.ActiveMQObjectMessage;
import org.activemq.message.BrokerAdminCommand;
import org.activemq.message.CapacityInfo;
import org.activemq.message.CleanupConnectionInfo;
import org.activemq.message.ConnectionInfo;
import org.activemq.message.ConsumerInfo;
import org.activemq.message.Packet;
import org.activemq.message.PacketListener;
import org.activemq.message.ProducerInfo;
import org.activemq.message.Receipt;
import org.activemq.message.ResponseReceipt;
import org.activemq.message.SessionInfo;
import org.activemq.message.WireFormatInfo;
import org.activemq.message.XATransactionInfo;
import org.activemq.transport.TransportChannel;
import org.activemq.transport.TransportStatusEvent;
import org.activemq.transport.TransportStatusEventListener;
import org.activemq.util.IdGenerator;
import org.activemq.util.JMSExceptionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQConnection
implements Connection,
PacketListener,
ExceptionListener,
TopicConnection,
QueueConnection,
StatsCapable,
CapacityMonitorEventListener,
TransportStatusEventListener,
Closeable {
    public static final String DEFAULT_USER = "defaultUser";
    public static final String DEFAULT_BROKER_URL = "tcp://localhost:61616";
    public static final String DEFAULT_URL = "peer://development";
    public static final String DEFAULT_PASSWORD = "defaultPassword";
    private static final Log log;
    private static final int DEFAULT_CONNECTION_MEMORY_LIMIT = 0xA00000;
    private ActiveMQConnectionFactory factory;
    private String userName;
    private String password;
    protected String clientID;
    private int sendCloseTimeout = 2000;
    private TransportChannel transportChannel;
    private ExceptionListener exceptionListener;
    private ActiveMQPrefetchPolicy prefetchPolicy;
    private JMSStatsImpl factoryStats;
    private MemoryBoundedObjectManager memoryManager;
    private MemoryBoundedQueueManager boundedQueueManager;
    protected IdGenerator handleIdGenerator;
    private IdGenerator clientIdGenerator;
    protected IdGenerator packetIdGenerator;
    private IdGenerator sessionIdGenerator;
    private JMSConnectionStatsImpl stats;
    private CopyOnWriteArrayList sessions;
    private CopyOnWriteArrayList messageDispatchers;
    private CopyOnWriteArrayList connectionConsumers;
    private SynchronizedInt consumerNumberGenerator;
    private ActiveMQConnectionMetaData connectionMetaData;
    private boolean closed;
    private SynchronizedBoolean started;
    private boolean clientIDSet;
    private boolean isConnectionInfoSentToBroker;
    private boolean isTransportOK;
    private boolean startedTransport;
    private long startTime;
    private long flowControlSleepTime = 0L;
    private boolean quickClose;
    private boolean internalConnection;
    private boolean userSpecifiedClientID;
    protected boolean useAsyncSend = true;
    private int sendConnectionInfoTimeout = 30000;
    private boolean disableTimeStampsByDefault = false;
    private boolean J2EEcompliant = true;
    private boolean prepareMessageBodyOnSend = true;
    private boolean copyMessageOnSend = true;
    private boolean doMessageCompression = true;
    private int messageCompressionLimit = 32768;
    private int messageCompressionLevel = 1;
    private int messageCompressionStrategy = 0;
    private boolean doMessageFragmentation = false;
    private int messageFragmentationLimit = 65536;
    private boolean cachingEnabled = true;
    private boolean optimizedMessageDispatch = false;
    private CopyOnWriteArrayList transientConsumedRedeliverCache;
    private FilterFactory filterFactory;
    private Map tempDestinationMap;
    private Map validDestinationsMap;
    private String resourceManagerId;
    private final ConcurrentHashMap assemblies = new ConcurrentHashMap();
    private final ByteArrayFragmentation fragmentation = new ByteArrayFragmentation();
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ActiveMQConnection makeConnection() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        return (ActiveMQConnection)factory.createConnection();
    }

    public static ActiveMQConnection makeConnection(String uri) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
        return (ActiveMQConnection)factory.createConnection();
    }

    public static ActiveMQConnection makeConnection(String user, String password, String uri) throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(user, password, uri);
        return (ActiveMQConnection)factory.createConnection();
    }

    public ActiveMQConnection(ActiveMQConnectionFactory factory, String theUserName, String thePassword, TransportChannel transportChannel) throws JMSException {
        this(factory, theUserName, thePassword);
        this.transportChannel = transportChannel;
        this.transportChannel.setPacketListener(this);
        this.transportChannel.setExceptionListener(this);
        this.transportChannel.addTransportStatusEventListener(this);
        this.isTransportOK = true;
    }

    protected ActiveMQConnection(ActiveMQConnectionFactory factory, String theUserName, String thePassword) {
        this.factory = factory;
        this.userName = theUserName;
        this.password = thePassword;
        this.clientIdGenerator = new IdGenerator();
        this.packetIdGenerator = new IdGenerator();
        this.handleIdGenerator = new IdGenerator();
        this.sessionIdGenerator = new IdGenerator();
        this.consumerNumberGenerator = new SynchronizedInt(0);
        this.sessions = new CopyOnWriteArrayList();
        this.messageDispatchers = new CopyOnWriteArrayList();
        this.connectionConsumers = new CopyOnWriteArrayList();
        this.connectionMetaData = new ActiveMQConnectionMetaData();
        this.started = new SynchronizedBoolean(false);
        this.startTime = System.currentTimeMillis();
        this.prefetchPolicy = new ActiveMQPrefetchPolicy();
        this.memoryManager = new MemoryBoundedObjectManager(this.clientID, 0xA00000L);
        this.boundedQueueManager = new MemoryBoundedQueueManager(this.memoryManager);
        this.memoryManager.addCapacityEventListener(this);
        boolean transactional = this instanceof XAConnection;
        this.factoryStats = factory.getFactoryStats();
        this.factoryStats.addConnection(this);
        this.stats = new JMSConnectionStatsImpl((List)this.sessions, transactional);
        this.transientConsumedRedeliverCache = new CopyOnWriteArrayList();
        this.tempDestinationMap = new ConcurrentHashMap();
        this.validDestinationsMap = new ConcurrentHashMap();
        factory.onConnectionCreate(this);
    }

    public StatsImpl getStats() {
        return this.stats;
    }

    public JMSConnectionStatsImpl getConnectionStats() {
        return this.stats;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.sendConnectionInfoToBroker();
        return new ActiveMQSession(this, transacted ? 0 : (acknowledgeMode == 0 ? 1 : acknowledgeMode));
    }

    public Session createSession(boolean transacted, int acknowledgeMode, boolean optimizedDispatch) throws JMSException {
        this.checkClosed();
        this.sendConnectionInfoToBroker();
        return new ActiveMQSession(this, transacted ? 0 : acknowledgeMode, optimizedDispatch);
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this.clientID;
    }

    public void setClientID(String newClientID) throws JMSException {
        if (this.clientIDSet) {
            throw new IllegalStateException("The clientID has already been set");
        }
        if (this.isConnectionInfoSentToBroker) {
            throw new IllegalStateException("Setting clientID on a used Connection is not allowed");
        }
        this.checkClosed();
        this.clientID = newClientID;
        this.userSpecifiedClientID = true;
        this.ensureClientIDInitialised();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this.connectionMetaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = listener;
        this.transportChannel.setExceptionListener(listener);
    }

    public void start() throws JMSException {
        this.checkClosed();
        if (this.started.commit(false, true)) {
            this.sendConnectionInfoToBroker(this.sendConnectionInfoTimeout, true, false);
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.start();
            }
        }
    }

    protected boolean isStarted() {
        return this.started.get();
    }

    public void stop() throws JMSException {
        this.checkClosed();
        if (this.started.commit(true, false)) {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.stop();
            }
            this.sendConnectionInfoToBroker(2000, true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        this.transportChannel.setPendingStop(true);
        ActiveMQConnection activeMQConnection = this;
        synchronized (activeMQConnection) {
            if (!this.closed) {
                this.memoryManager.removeCapacityEventListener(this);
                try {
                    this.closeTemporaryDestinations();
                    Iterator i = this.sessions.iterator();
                    while (i.hasNext()) {
                        ActiveMQSession s = (ActiveMQSession)i.next();
                        s.close();
                    }
                    i = this.connectionConsumers.iterator();
                    while (i.hasNext()) {
                        ActiveMQConnectionConsumer c = (ActiveMQConnectionConsumer)i.next();
                        c.close();
                    }
                    try {
                        this.sendConnectionInfoToBroker(this.sendCloseTimeout, true, true);
                    }
                    catch (TimeoutExpiredException e) {
                        log.warn((Object)("Failed to send close to broker, timeout expired of: " + this.sendCloseTimeout + " millis"));
                    }
                    this.connectionConsumers.clear();
                    this.messageDispatchers.clear();
                    this.transportChannel.stop();
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.sessions.clear();
                    this.started.set(false);
                    this.factory.onConnectionClose(this);
                    throw throwable;
                }
                this.sessions.clear();
                this.started.set(false);
                this.factory.onConnectionClose(this);
                this.closed = true;
                this.transientConsumedRedeliverCache.clear();
                this.validDestinationsMap.clear();
                this.factoryStats.removeConnection(this);
            }
        }
    }

    public void terminateBrokerVM() throws JMSException {
        BrokerAdminCommand command = new BrokerAdminCommand();
        command.setCommand("SHUTDOWN_BROKER_VM");
        this.asyncSendPacket(command);
    }

    protected synchronized void checkClosed() throws JMSException {
        if (!this.startedTransport) {
            this.startedTransport = true;
            this.transportChannel.setCachingEnabled(this.isCachingEnabled());
            if (!this.useAsyncSend) {
                this.transportChannel.setNoDelay(true);
            }
            this.transportChannel.setUsedInternally(this.internalConnection);
            this.transportChannel.start();
            if (this.transportChannel.doesSupportWireFormatVersioning()) {
                WireFormatInfo info = new WireFormatInfo();
                info.setVersion(this.transportChannel.getCurrentWireFormatVersion());
                this.asyncSendPacket(info);
            }
        }
        if (this.closed) {
            throw new ConnectionClosedException();
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination(destination));
        info.setSelector(messageSelector);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination(destination));
        info.setSelector(messageSelector);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        info.setNoLocal(noLocal);
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination((Destination)topic));
        info.setSelector(messageSelector);
        info.setConsumerName(subscriptionName);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages, boolean noLocal) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination((Destination)topic));
        info.setSelector(messageSelector);
        info.setConsumerName(subscriptionName);
        info.setNoLocal(noLocal);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void consume(Packet packet) {
        if (this.closed || packet == null) return;
        if (packet.isJMSMessage()) {
            long timeStamp;
            long expiration;
            ActiveMQMessage message = (ActiveMQMessage)packet;
            message.setReadOnly(true);
            message.setConsumerIdentifer(this.clientID);
            if (this.transportChannel.isMulticast() && (expiration = message.getJMSExpiration()) > 0L && (timeStamp = System.currentTimeMillis()) > expiration) {
                if (!log.isDebugEnabled()) return;
                log.debug((Object)("Discarding expired message: " + message));
                return;
            }
            try {
                message = this.assembleMessage(message);
                if (message == null) return;
                int count = 0;
                Iterator i = this.messageDispatchers.iterator();
                while (i.hasNext()) {
                    ActiveMQMessageDispatcher dispatcher = (ActiveMQMessageDispatcher)i.next();
                    if (!dispatcher.isTarget(message)) continue;
                    if (count > 0) {
                        message = message.deepCopy();
                    }
                    dispatcher.dispatch(message);
                    ++count;
                }
                return;
            }
            catch (JMSException jmsEx) {
                this.handleAsyncException(jmsEx);
                return;
            }
        }
        if (packet.getPacketType() == 27) {
            CapacityInfo info = (CapacityInfo)packet;
            this.flowControlSleepTime = info.getFlowControlTimeout();
            return;
        }
        if (packet.getPacketType() != 30 || !packet.isReceiptRequired()) return;
        Receipt receipt = new Receipt();
        receipt.setCorrelationId(packet.getId());
        receipt.setReceiptRequired(false);
        try {
            this.asyncSendPacket(receipt);
            return;
        }
        catch (JMSException jmsEx) {
            this.handleAsyncException(jmsEx);
        }
    }

    private final ActiveMQMessage assembleMessage(ActiveMQMessage message) {
        ActiveMQMessage result = message;
        if (message != null && !this.isInternalConnection() && message.isMessagePart()) {
            if (message.getNumberOfParts() == 1) {
                message.resetMessagePart();
                result = message;
            } else {
                result = null;
                String parentId = message.getParentMessageID();
                ActiveMQMessage[] array = (ActiveMQMessage[])this.assemblies.get((Object)parentId);
                if (array == null) {
                    array = new ActiveMQMessage[message.getNumberOfParts()];
                    this.assemblies.put((Object)parentId, (Object)array);
                }
                array[message.getPartNumber()] = message;
                boolean complete = true;
                for (int i = 0; i < array.length; ++i) {
                    complete &= array[i] != null;
                }
                if (complete) {
                    result = array[0];
                    ByteArray[] bas = new ByteArray[array.length];
                    try {
                        for (int i = 0; i < bas.length; ++i) {
                            bas[i] = array[i].getBodyAsBytes();
                            if (i < 1) continue;
                            array[i].clearBody();
                        }
                        ByteArray ba = this.fragmentation.assemble(bas);
                        result.setBodyAsBytes(ba);
                    }
                    catch (IOException ioe) {
                        JMSException jmsEx = new JMSException("Failed to assemble fragment message: " + parentId);
                        jmsEx.setLinkedException((Exception)ioe);
                        this.onException(jmsEx);
                    }
                    catch (JMSException jmsEx) {
                        this.onException(jmsEx);
                    }
                }
            }
        }
        return result;
    }

    public void onException(JMSException jmsEx) {
        this.handleAsyncException(jmsEx);
        this.isTransportOK = false;
        try {
            this.close();
        }
        catch (JMSException ex) {
            log.debug((Object)"Exception closing the connection", (Throwable)ex);
        }
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.sendConnectionInfoToBroker();
        return new ActiveMQTopicSession((ActiveMQSession)this.createSession(transacted, acknowledgeMode));
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination((Destination)topic));
        info.setSelector(messageSelector);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        this.sendConnectionInfoToBroker();
        return new ActiveMQQueueSession((ActiveMQSession)this.createSession(transacted, acknowledgeMode));
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.ensureClientIDInitialised();
        ConsumerInfo info = new ConsumerInfo();
        info.setConsumerId(this.handleIdGenerator.generateId());
        info.setDestination(ActiveMQMessageTransformation.transformDestination((Destination)queue));
        info.setSelector(messageSelector);
        info.setConsumerNo(this.handleIdGenerator.getNextShortSequence());
        return new ActiveMQConnectionConsumer(this, sessionPool, info, maxMessages);
    }

    public void checkClientIDWasManuallySpecified() throws JMSException {
        if (!this.userSpecifiedClientID) {
            throw new JMSException("You cannot create a durable subscriber without specifying a unique clientID on a Connection");
        }
    }

    public void statusChanged(TransportStatusEvent event) {
        log.info((Object)("channel status changed: " + event));
        if (event.getChannelStatus() == 3) {
            this.isTransportOK = true;
            this.doReconnect();
        } else if (event.getChannelStatus() == 2) {
            this.isTransportOK = false;
            this.clearMessagesInProgress();
        }
    }

    public void asyncSendPacket(Packet packet) throws JMSException {
        this.asyncSendPacket(packet, true);
    }

    public void asyncSendPacket(Packet packet, boolean doSendWhileReconnecting) throws JMSException {
        if (this.isTransportOK && !this.closed && (doSendWhileReconnecting || this.transportChannel.isTransportConnected())) {
            packet.setId(this.packetIdGenerator.getNextShortSequence());
            packet.setReceiptRequired(false);
            if (packet.isJMSMessage() && this.flowControlSleepTime > 0L) {
                try {
                    Thread.sleep(this.flowControlSleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.transportChannel.asyncSend(packet);
        }
    }

    public void syncSendPacket(Packet packet) throws JMSException {
        this.syncSendPacket(packet, 0);
    }

    public void syncSendPacket(Packet packet, int timeout) throws JMSException {
        if (this.isTransportOK && !this.closed) {
            packet.setId(this.packetIdGenerator.getNextShortSequence());
            packet.setReceiptRequired(true);
            Receipt receipt = this.transportChannel.send(packet, timeout);
            if (receipt != null && receipt.isFailed()) {
                Throwable e = receipt.getException();
                if (e != null) {
                    throw JMSExceptionHelper.newJMSException(e);
                }
                throw new JMSException("syncSendPacket failed with unknown exception");
            }
        } else {
            if (this.closed) {
                throw new ConnectionClosedException();
            }
            throw new JMSException("syncSendTimedOut: connection no longer OK");
        }
    }

    public Receipt syncSendRequest(Packet packet) throws JMSException {
        this.checkClosed();
        if (this.isTransportOK && !this.closed) {
            packet.setReceiptRequired(true);
            packet.setId(this.packetIdGenerator.getNextShortSequence());
            Receipt receipt = this.transportChannel.send(packet);
            if (receipt != null && receipt.isFailed()) {
                Throwable e = receipt.getException();
                if (e != null) {
                    throw (JMSException)new JMSException(e.getMessage()).initCause(e);
                }
                throw new JMSException("syncSendPacket failed with unknown exception");
            }
            return receipt;
        }
        if (this.closed) {
            throw new ConnectionClosedException();
        }
        throw new JMSException("syncSendTimedOut: connection no longer OK");
    }

    public ActiveMQPrefetchPolicy getPrefetchPolicy() {
        return this.prefetchPolicy;
    }

    public void setPrefetchPolicy(ActiveMQPrefetchPolicy prefetchPolicy) {
        this.prefetchPolicy = prefetchPolicy;
    }

    public int getSendCloseTimeout() {
        return this.sendCloseTimeout;
    }

    public void setSendCloseTimeout(int sendCloseTimeout) {
        this.sendCloseTimeout = sendCloseTimeout;
    }

    public int getSendConnectionInfoTimeout() {
        return this.sendConnectionInfoTimeout;
    }

    public void setSendConnectionInfoTimeout(int sendConnectionInfoTimeout) {
        this.sendConnectionInfoTimeout = sendConnectionInfoTimeout;
    }

    public TransportChannel getTransportChannel() {
        return this.transportChannel;
    }

    public String getInitializedClientID() throws JMSException {
        this.ensureClientIDInitialised();
        return this.clientID;
    }

    protected void addSession(ActiveMQSession session) throws JMSException {
        this.sessions.add((Object)session);
        this.addMessageDispatcher(session);
        if (this.started.get()) {
            session.start();
        }
        SessionInfo info = this.createSessionInfo(session);
        info.setStarted(true);
        this.asyncSendPacket(info);
    }

    protected void removeSession(ActiveMQSession session) throws JMSException {
        this.sessions.remove((Object)session);
        this.removeMessageDispatcher(session);
        SessionInfo info = this.createSessionInfo(session);
        info.setStarted(false);
        this.asyncSendPacket(info, false);
    }

    private SessionInfo createSessionInfo(ActiveMQSession session) {
        SessionInfo info = new SessionInfo();
        info.setClientId(this.clientID);
        info.setSessionId(session.getSessionId());
        info.setStartTime(session.getStartTime());
        return info;
    }

    protected void addConnectionConsumer(ActiveMQConnectionConsumer connectionConsumer) throws JMSException {
        this.connectionConsumers.add((Object)connectionConsumer);
        this.addMessageDispatcher(connectionConsumer);
    }

    protected void removeConnectionConsumer(ActiveMQConnectionConsumer connectionConsumer) {
        this.connectionConsumers.add((Object)connectionConsumer);
        this.removeMessageDispatcher(connectionConsumer);
    }

    protected void addMessageDispatcher(ActiveMQMessageDispatcher messageDispatch) throws JMSException {
        this.messageDispatchers.add((Object)messageDispatch);
    }

    protected void removeMessageDispatcher(ActiveMQMessageDispatcher messageDispatcher) {
        this.messageDispatchers.remove((Object)messageDispatcher);
    }

    protected void handleAsyncException(JMSException jmsEx) {
        if (!this.closed) {
            if (this.exceptionListener != null) {
                this.exceptionListener.onException(jmsEx);
            } else {
                log.warn((Object)("Async exception with no exception listener: " + (Object)((Object)jmsEx)), (Throwable)jmsEx);
            }
        }
    }

    protected void sendConnectionInfoToBroker() throws JMSException {
        this.sendConnectionInfoToBroker(this.sendConnectionInfoTimeout, this.closed, false);
    }

    protected void sendConnectionInfoToBroker(int timeout, boolean forceResend, boolean closing) throws JMSException {
        if (this.isConnectionInfoSentToBroker && !forceResend) {
            return;
        }
        this.fragmentation.setFragmentationLimit(this.getMessageFragmentationLimit());
        this.isConnectionInfoSentToBroker = true;
        this.ensureClientIDInitialised();
        ConnectionInfo info = new ConnectionInfo();
        info.setClientId(this.clientID);
        info.setHostName(IdGenerator.getHostName());
        info.setUserName(this.userName);
        info.setPassword(this.password);
        info.setStartTime(this.startTime);
        info.setStarted(this.started.get());
        info.setClosed(this.closed || closing);
        info.setClientVersion(this.connectionMetaData.getProviderVersion());
        info.setWireFormatVersion(this.transportChannel.getCurrentWireFormatVersion());
        if (info.getProperties() != null) {
            info.getProperties().setProperty(ConnectionInfo.NO_DELAY_PROPERTY, new Boolean(!this.useAsyncSend).toString());
        }
        if (this.quickClose && info.isClosed()) {
            this.asyncSendPacket(info);
        } else {
            this.syncSendPacket(info, timeout);
        }
    }

    public void setConnectionMemoryLimit(int newMemoryLimit) {
        this.memoryManager.setValueLimit(newMemoryLimit);
    }

    public int getConnectionMemoryLimit() {
        return (int)this.memoryManager.getValueLimit();
    }

    public void capacityChanged(CapacityMonitorEvent event) {
        CapacityInfo info = new CapacityInfo();
        info.setResourceName(event.getMonitorName());
        info.setCapacity(event.getCapacity());
        try {
            this.asyncSendPacket(info, false);
        }
        catch (JMSException e) {
            JMSException jmsEx = new JMSException("failed to send change in capacity");
            jmsEx.setLinkedException((Exception)((Object)e));
            this.handleAsyncException(jmsEx);
        }
    }

    protected int getNextConsumerNumber() {
        return this.consumerNumberGenerator.increment();
    }

    protected short generateSessionId() {
        return this.sessionIdGenerator.getNextShortSequence();
    }

    private synchronized void ensureClientIDInitialised() {
        if (this.clientID == null || this.clientID.trim().equals("")) {
            this.clientID = this.clientIdGenerator.generateId();
        }
        this.transportChannel.setClientID(this.clientID);
        this.clientIDSet = true;
    }

    protected MemoryBoundedQueue getMemoryBoundedQueue(String name) {
        return this.boundedQueueManager.getMemoryBoundedQueue(name);
    }

    protected void doReconnect() {
        try {
            this.sendConnectionInfoToBroker(this.sendConnectionInfoTimeout, true, false);
            Iterator iter = this.sessions.iterator();
            while (iter.hasNext()) {
                ActiveMQSession session = (ActiveMQSession)iter.next();
                SessionInfo sessionInfo = this.createSessionInfo(session);
                sessionInfo.setStarted(true);
                this.asyncSendPacket(sessionInfo, false);
                Iterator consumersIterator = session.consumers.iterator();
                while (consumersIterator.hasNext()) {
                    ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)consumersIterator.next();
                    ConsumerInfo consumerInfo = session.createConsumerInfo(consumer);
                    consumerInfo.setStarted(true);
                    this.asyncSendPacket(consumerInfo, false);
                }
                Iterator producersIterator = session.producers.iterator();
                while (producersIterator.hasNext()) {
                    ActiveMQMessageProducer producer = (ActiveMQMessageProducer)producersIterator.next();
                    ProducerInfo producerInfo = session.createProducerInfo(producer);
                    producerInfo.setStarted(true);
                    this.asyncSendPacket(producerInfo, false);
                }
                CapacityMonitorEvent event = this.memoryManager.generateCapacityMonitorEvent();
                if (event == null) continue;
                this.capacityChanged(event);
            }
        }
        catch (JMSException jmsEx) {
            log.error((Object)"Failed to do reconnection");
            this.handleAsyncException(jmsEx);
            this.isTransportOK = false;
        }
    }

    public boolean isUseAsyncSend() {
        return this.useAsyncSend;
    }

    public void setUseAsyncSend(boolean useAsyncSend) {
        this.useAsyncSend = useAsyncSend;
    }

    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    public void setCachingEnabled(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
    }

    public boolean isJ2EEcompliant() {
        return this.J2EEcompliant;
    }

    public void setJ2EEcompliant(boolean ecompliant) {
        this.J2EEcompliant = ecompliant;
    }

    public boolean isInternalConnection() {
        return this.internalConnection;
    }

    public void setInternalConnection(boolean internalConnection) {
        this.internalConnection = internalConnection;
    }

    public boolean isDoMessageCompression() {
        return this.doMessageCompression && this.transportChannel.doesSupportMessageCompression();
    }

    public void setDoMessageCompression(boolean doMessageCompression) {
        this.doMessageCompression = doMessageCompression && this.transportChannel.doesSupportMessageCompression();
    }

    public boolean isDoMessageFragmentation() {
        return this.doMessageFragmentation && this.transportChannel.doesSupportMessageFragmentation();
    }

    public void setDoMessageFragmentation(boolean doMessageFragmentation) {
        this.doMessageFragmentation = doMessageFragmentation && this.transportChannel.doesSupportMessageFragmentation();
    }

    public int getMessageCompressionLevel() {
        return this.messageCompressionLevel;
    }

    public void setMessageCompressionLevel(int messageCompressionLevel) {
        this.messageCompressionLevel = messageCompressionLevel;
    }

    public int getMessageCompressionLimit() {
        return this.messageCompressionLimit;
    }

    public void setMessageCompressionLimit(int messageCompressionLimit) {
        this.messageCompressionLimit = messageCompressionLimit;
    }

    public int getMessageCompressionStrategy() {
        return this.messageCompressionStrategy;
    }

    public void setMessageCompressionStrategy(int messageCompressionStrategy) {
        this.messageCompressionStrategy = messageCompressionStrategy;
    }

    public int getMessageFragmentationLimit() {
        return this.messageFragmentationLimit;
    }

    public void setMessageFragmentationLimit(int messageFragmentationLimit) {
        this.messageFragmentationLimit = messageFragmentationLimit;
    }

    public boolean isDisableTimeStampsByDefault() {
        return this.disableTimeStampsByDefault;
    }

    public void setDisableTimeStampsByDefault(boolean disableTimeStampsByDefault) {
        this.disableTimeStampsByDefault = disableTimeStampsByDefault;
    }

    public boolean isPrepareMessageBodyOnSend() {
        return this.prepareMessageBodyOnSend;
    }

    public void setPrepareMessageBodyOnSend(boolean prePrepareMessageOnSend) {
        this.prepareMessageBodyOnSend = prePrepareMessageOnSend;
    }

    public boolean isCopyMessageOnSend() {
        return this.copyMessageOnSend;
    }

    public void setCopyMessageOnSend(boolean copyMessageOnSend) {
        this.copyMessageOnSend = copyMessageOnSend;
    }

    public boolean isQuickClose() {
        return this.quickClose;
    }

    public void setQuickClose(boolean quickClose) {
        this.quickClose = quickClose;
    }

    public boolean isOptimizedMessageDispatch() {
        return this.optimizedMessageDispatch;
    }

    public void setOptimizedMessageDispatch(boolean optimizedMessageDispatch) {
        this.optimizedMessageDispatch = optimizedMessageDispatch;
    }

    protected void clearMessagesInProgress() {
        Iterator i = this.sessions.iterator();
        while (i.hasNext()) {
            ActiveMQSession session = (ActiveMQSession)i.next();
            session.clearMessagesInProgress();
        }
    }

    public void destroyDestination(ActiveMQDestination destination) throws JMSException {
        BrokerAdminCommand command = new BrokerAdminCommand();
        command.setCommand("DESTROY_DESTINATION");
        command.setDestination(destination);
        this.syncSendPacket(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws JMSException {
        try {
            Iterator i = this.sessions.iterator();
            while (i.hasNext()) {
                ActiveMQSession s = (ActiveMQSession)i.next();
                s.close();
            }
            i = this.connectionConsumers.iterator();
            while (i.hasNext()) {
                ActiveMQConnectionConsumer c = (ActiveMQConnectionConsumer)i.next();
                c.close();
            }
            this.connectionConsumers.clear();
            this.messageDispatchers.clear();
        }
        finally {
            this.sessions.clear();
            this.started.set(false);
        }
        this.setExceptionListener(null);
        this.clientIDSet = false;
        this.isConnectionInfoSentToBroker = false;
        CleanupConnectionInfo cleanupInfo = new CleanupConnectionInfo();
        cleanupInfo.setClientId(this.getClientID());
        this.asyncSendPacket(cleanupInfo);
    }

    public void changeUserInfo(String theUserName, String thePassword) throws JMSException {
        if (this.isConnectionInfoSentToBroker) {
            throw new IllegalStateException("changeUserInfo used Connection is not allowed");
        }
        this.userName = theUserName;
        this.password = thePassword;
    }

    protected void addToTransientConsumedRedeliverCache(ActiveMQMessage message) {
        this.transientConsumedRedeliverCache.add((Object)message);
    }

    protected void replayTransientConsumedRedeliveredMessages(ActiveMQSession session, ActiveMQMessageConsumer consumer) throws JMSException {
        if (consumer.getDestination().isTopic() && !this.transientConsumedRedeliverCache.isEmpty()) {
            Filter filter = this.getFilterFactory().createFilter(consumer.getDestination(), consumer.getMessageSelector());
            if (consumer.isNoLocal()) {
                filter = new AndFilter(filter, new NoLocalFilter(this.clientID));
            }
            Iterator i = this.transientConsumedRedeliverCache.iterator();
            while (i.hasNext()) {
                ActiveMQMessage message = (ActiveMQMessage)i.next();
                if (!filter.matches(message)) continue;
                this.transientConsumedRedeliverCache.remove((Object)message);
                message.setMessageAcknowledge(session);
                message.setJMSRedelivered(true);
                message.setConsumerNos(new int[]{consumer.getConsumerNumber()});
                consumer.processMessage(message);
            }
        }
    }

    private FilterFactory getFilterFactory() {
        if (this.filterFactory == null) {
            this.filterFactory = new FilterFactoryImpl();
        }
        return this.filterFactory;
    }

    protected void startTemporaryDestination(ActiveMQDestination dest) throws JMSException {
        TempDestinationAdvisoryEvent event;
        if (dest != null && dest.isTemporary() && (event = (TempDestinationAdvisoryEvent)this.tempDestinationMap.get(dest)) == null) {
            event = new TempDestinationAdvisoryEvent(dest, true);
            this.tempDestinationMap.put(dest, event);
            ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
            msg.setObject(event);
            msg.setJMSDeliveryMode(1);
            msg.setJMSDestination(dest.getTopicForTempAdvisory());
            msg.setJMSMessageID("ID:" + dest.getPhysicalName() + " .started");
            this.syncSendPacket(msg);
        }
    }

    protected void stopTemporaryDestination(ActiveMQDestination dest) throws JMSException {
        TempDestinationAdvisoryEvent event;
        if (dest != null && dest.isTemporary() && (event = (TempDestinationAdvisoryEvent)this.tempDestinationMap.remove(dest)) != null) {
            event.setStarted(false);
            ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
            msg.setObject(event);
            msg.setJMSDeliveryMode(1);
            msg.setJMSDestination(dest.getTopicForTempAdvisory());
            msg.setJMSMessageID("ID:" + dest.getPhysicalName() + " .stopped");
            this.syncSendPacket(msg);
        }
    }

    protected void closeTemporaryDestinations() throws JMSException {
        Iterator i = this.tempDestinationMap.keySet().iterator();
        while (i.hasNext()) {
            ActiveMQDestination dest = (ActiveMQDestination)i.next();
            this.stopTemporaryDestination(dest);
        }
    }

    protected void startAdvisoryForTempDestination(Destination d) throws JMSException {
        TempDestinationAdvisor test;
        ActiveMQDestination dest;
        if (d != null && (dest = ActiveMQMessageTransformation.transformDestination(d)).isTemporary() && (test = (TempDestinationAdvisor)this.validDestinationsMap.get(dest)) == null) {
            test = new TempDestinationAdvisor(this, dest);
            test.start();
            this.validDestinationsMap.put(dest, test);
        }
    }

    protected void stopAdvisoryForTempDestination(ActiveMQDestination d) throws JMSException {
        TempDestinationAdvisor test;
        ActiveMQDestination dest;
        if (d != null && (dest = ActiveMQMessageTransformation.transformDestination(d)).isTemporary() && (test = (TempDestinationAdvisor)this.validDestinationsMap.remove(dest)) != null) {
            test.stop();
        }
    }

    protected final void validateDestination(ActiveMQDestination dest) throws JMSException {
        if (dest != null && dest.isTemporary()) {
            TempDestinationAdvisor test = (TempDestinationAdvisor)this.validDestinationsMap.get(dest);
            if (dest.isDeleted() || test == null || !test.isActive(dest)) {
                throw new JMSException("Cannot publish to a deleted Destination: " + dest);
            }
        }
    }

    public synchronized String getResourceManagerId() throws JMSException {
        if (this.resourceManagerId == null) {
            this.resourceManagerId = this.determineResourceManagerId();
        }
        return this.resourceManagerId;
    }

    private String determineResourceManagerId() throws JMSException {
        XATransactionInfo info = new XATransactionInfo();
        info.setType(113);
        ResponseReceipt receipt = (ResponseReceipt)this.syncSendRequest(info);
        String rmId = (String)((Object)receipt.getResult());
        if (!$assertionsDisabled && rmId == null) {
            throw new AssertionError();
        }
        return rmId;
    }

    public ByteArrayFragmentation getFragmentation() {
        return this.fragmentation;
    }

    public ConcurrentHashMap getAssemblies() {
        return this.assemblies;
    }

    static {
        $assertionsDisabled = !ActiveMQConnection.class.desiredAssertionStatus();
        log = LogFactory.getLog((Class)ActiveMQConnection.class);
    }
}

