/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.List;
import java.util.Properties;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQMessage;
import org.activemq.message.MessageAck;
import org.activemq.transport.stomp.AckListener;
import org.activemq.transport.stomp.Command;
import org.activemq.transport.stomp.HeaderParser;
import org.activemq.transport.stomp.PacketEnvelope;
import org.activemq.transport.stomp.StompWireFormat;

class Ack
implements Command {
    private final StompWireFormat format;
    private static final HeaderParser parser = new HeaderParser();

    Ack(StompWireFormat format) {
        this.format = format;
    }

    public PacketEnvelope build(String commandLine, DataInput in) throws IOException {
        System.out.println("ACK received");
        Properties headers = parser.parse(in);
        String message_id = headers.getProperty("message-id");
        if (message_id == null) {
            throw new ProtocolException("ACK received without a message-id to acknowledge!");
        }
        List listeners = this.format.getAckListeners();
        for (int i = 0; i < listeners.size(); ++i) {
            String tx_id;
            AckListener listener = (AckListener)listeners.get(i);
            if (!listener.handle(message_id)) continue;
            listeners.remove(i);
            ActiveMQMessage msg = listener.getMessage();
            MessageAck ack = new MessageAck();
            ack.setDestination((ActiveMQDestination)msg.getJMSDestination());
            ack.setConsumerId(listener.getConsumerId());
            ack.setMessageID(msg.getJMSMessageID());
            ack.setMessageRead(true);
            ack.setProducerKey(msg.getProducerKey());
            ack.setSequenceNumber(msg.getSequenceNumber());
            ack.setPersistent(msg.getJMSDeliveryMode() == 2);
            ack.setSessionId(this.format.getSessionId());
            if (headers.containsKey("transaction")) {
                tx_id = this.format.getTransactionId(headers.getProperty("transaction"));
                if (tx_id == null) {
                    throw new ProtocolException(headers.getProperty("transaction") + " is an invalid transaction id");
                }
                ack.setTransactionIDString(tx_id);
            } else if (this.format.isInDefaultTransaction()) {
                tx_id = this.format.getTransactionId("  ~~!  DEFAULT TRANSACTION !~~  ");
                ack.setTransactionIDString(tx_id);
            }
            while (in.readByte() != 0) {
            }
            return new PacketEnvelope(ack, headers);
        }
        while (in.readByte() != 0) {
        }
        throw new ProtocolException("Unexepected ACK received for message-id [" + message_id + "]");
    }
}

