/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.activemq.message.ActiveMQMessage;
import org.activemq.transport.stomp.DestinationNamer;
import org.activemq.transport.stomp.Stomp;

class FrameBuilder {
    private String command;
    private Properties headers = new Properties();
    private String body = "";

    public FrameBuilder(String command) {
        this.command = command;
    }

    public FrameBuilder addHeader(String key, String value) {
        if (value != null) {
            this.headers.setProperty(key, value);
        }
        return this;
    }

    public FrameBuilder addHeader(String key, long value) {
        this.headers.put(key, new Long(value));
        return this;
    }

    public FrameBuilder addHeaders(ActiveMQMessage message) {
        this.addHeader("destination", DestinationNamer.convert(message.getJMSActiveMQDestination()));
        this.addHeader("message-id", message.getJMSMessageID());
        this.addHeader("correlation-id", message.getJMSCorrelationID());
        this.addHeader("expires", message.getJMSExpiration());
        if (message.getJMSRedelivered()) {
            this.addHeader("redelivered", "true");
        }
        this.addHeader("priority", message.getJMSPriority());
        this.addHeader("reply-to", DestinationNamer.convert(message.getJMSReplyTo()));
        this.addHeader("timestamp", message.getJMSTimestamp());
        this.addHeader("type", message.getJMSType());
        this.headers.putAll((Map<?, ?>)message.getProperties());
        return this;
    }

    public FrameBuilder setBody(String body) {
        this.body = body;
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.command);
        buffer.append(Stomp.NEWLINE);
        Iterator<Object> iterator = this.headers.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String property = this.headers.getProperty(key);
            if (property == null) continue;
            buffer.append(key).append(":").append(property).append(Stomp.NEWLINE);
        }
        buffer.append(Stomp.NEWLINE);
        buffer.append(this.body);
        buffer.append("\u0000");
        buffer.append(Stomp.NEWLINE);
        return buffer.toString();
    }

    String toFrame() {
        return this.toString();
    }
}

