/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.stomp;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Properties;
import javax.jms.JMSException;
import org.activemq.message.ActiveMQDestination;
import org.activemq.message.ActiveMQTextMessage;
import org.activemq.transport.stomp.Command;
import org.activemq.transport.stomp.DestinationNamer;
import org.activemq.transport.stomp.HeaderParser;
import org.activemq.transport.stomp.PacketEnvelope;
import org.activemq.transport.stomp.StompWireFormat;

class Send
implements Command {
    private final HeaderParser parser = new HeaderParser();
    private final StompWireFormat format;

    Send(StompWireFormat format) {
        this.format = format;
    }

    public PacketEnvelope build(String commandLine, DataInput in) throws IOException {
        byte b;
        Object priority;
        Properties headers = this.parser.parse(in);
        String destination = (String)headers.remove("destination");
        ActiveMQTextMessage text = new ActiveMQTextMessage();
        text.setJMSMessageID(StompWireFormat.PACKET_IDS.generateId());
        ActiveMQDestination d = DestinationNamer.convert(destination);
        text.setJMSDestination(d);
        text.setJMSClientID(this.format.getClientId());
        text.setJMSCorrelationID((String)headers.remove("correlation-id"));
        Object expiration = headers.remove("expires");
        if (expiration != null) {
            text.setJMSExpiration(this.asLong(expiration));
        }
        if ((priority = headers.remove("priority")) != null) {
            text.setJMSExpiration(this.asInt(priority));
        }
        text.setJMSReplyTo(DestinationNamer.convert((String)headers.remove("reply-to")));
        text.setProperties(headers);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        while ((b = in.readByte()) != 0) {
            bytes.write(b);
        }
        bytes.close();
        String body = new String(bytes.toByteArray());
        try {
            text.setText(body);
        }
        catch (JMSException e) {
            throw new RuntimeException("Something is really wrong, we instantiated this thing!");
        }
        if (headers.containsKey("transaction")) {
            String tx_id = this.format.getTransactionId(headers.getProperty("transaction"));
            if (tx_id == null) {
                throw new ProtocolException(headers.getProperty("transaction") + " is an invalid transaction id");
            }
            text.setTransactionIDString(tx_id);
        } else if (this.format.isInDefaultTransaction()) {
            String tx_id = this.format.getTransactionId("  ~~!  DEFAULT TRANSACTION !~~  ");
            text.setTransactionIDString(tx_id);
        }
        return new PacketEnvelope(text, headers);
    }

    protected boolean asBool(Object value) {
        if (value != null) {
            return value.toString().equals("true");
        }
        return false;
    }

    protected long asLong(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.longValue();
        }
        return Long.parseLong(value.toString());
    }

    protected int asInt(Object value) {
        if (value instanceof Number) {
            Number n = (Number)value;
            return n.intValue();
        }
        return Integer.parseInt(value.toString());
    }
}

