/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.activemq.ActiveMQPrefetchPolicy;
import org.activemq.broker.BrokerContainer;
import org.activemq.service.Service;
import org.activemq.transport.NetworkChannel;
import org.activemq.transport.TransportChannelListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkConnector
implements Service {
    private static final Log log = LogFactory.getLog((Class)NetworkConnector.class);
    private BrokerContainer brokerContainer;
    private List networkChannels = new ArrayList();
    private Map localDetails = new HashMap();
    private String remoteUserName;
    private String remotePassword;
    protected PooledExecutor threadPool;
    private ActiveMQPrefetchPolicy localPrefetchPolicy = new ActiveMQPrefetchPolicy();
    private ActiveMQPrefetchPolicy remotePrefetchPolicy = new ActiveMQPrefetchPolicy();

    public NetworkConnector(BrokerContainer brokerContainer) {
        this.brokerContainer = brokerContainer;
        this.threadPool = new PooledExecutor();
    }

    public void start() throws JMSException {
        Iterator iter = this.networkChannels.iterator();
        while (iter.hasNext()) {
            NetworkChannel networkChannel = (NetworkChannel)iter.next();
            networkChannel.setBrokerContainer(this.getBrokerContainer());
            networkChannel.setThreadPool(this.threadPool);
            networkChannel.start();
        }
    }

    public void stop() throws JMSException {
        Iterator iter = this.networkChannels.iterator();
        while (iter.hasNext()) {
            NetworkChannel networkChannel = (NetworkChannel)iter.next();
            try {
                networkChannel.stop();
            }
            catch (JMSException e) {
                log.warn((Object)("Failed to stop network channel: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    public void setTransportChannelListener(TransportChannelListener listener) {
    }

    public BrokerContainer getBrokerContainer() {
        return this.brokerContainer;
    }

    public PooledExecutor getThreadPool() {
        return this.threadPool;
    }

    public List getNetworkChannels() {
        return this.networkChannels;
    }

    public Map getLocalDetails() {
        return this.localDetails;
    }

    public void setLocalDetails(Map localDetails) {
        this.localDetails = localDetails;
    }

    public String getRemotePassword() {
        return this.remotePassword;
    }

    public void setRemotePassword(String remotePassword) {
        this.remotePassword = remotePassword;
    }

    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    public void setRemoteUserName(String remoteUserName) {
        this.remoteUserName = remoteUserName;
    }

    public void setNetworkChannels(List networkChannels) {
        this.networkChannels = networkChannels;
    }

    public NetworkChannel addNetworkChannel(String uri) throws JMSException {
        NetworkChannel networkChannel = this.createNetworkChannel(uri);
        this.addNetworkChannel(networkChannel);
        return networkChannel;
    }

    public void addNetworkChannel(NetworkChannel networkChannel) throws JMSException {
        this.configure(networkChannel);
        this.networkChannels.add(networkChannel);
    }

    public void removeNetworkChannel(NetworkChannel networkChannel) {
        this.networkChannels.remove(networkChannel);
    }

    public ActiveMQPrefetchPolicy getLocalPrefetchPolicy() {
        return this.localPrefetchPolicy;
    }

    public void setLocalPrefetchPolicy(ActiveMQPrefetchPolicy localPrefetchPolicy) {
        this.localPrefetchPolicy = localPrefetchPolicy;
    }

    public ActiveMQPrefetchPolicy getRemotePrefetchPolicy() {
        return this.remotePrefetchPolicy;
    }

    public void setRemotePrefetchPolicy(ActiveMQPrefetchPolicy remotePrefetchPolicy) {
        this.remotePrefetchPolicy = remotePrefetchPolicy;
    }

    public int getLocalDurableTopicPrefetch() {
        return this.localPrefetchPolicy.getDurableTopicPrefetch();
    }

    public void setLocalDurableTopicPrefetch(int durableTopicPrefetch) {
        this.localPrefetchPolicy.setDurableTopicPrefetch(durableTopicPrefetch);
    }

    public int getLocalQueuePrefetch() {
        return this.localPrefetchPolicy.getQueuePrefetch();
    }

    public void setLocalQueuePrefetch(int queuePrefetch) {
        this.localPrefetchPolicy.setQueuePrefetch(queuePrefetch);
    }

    public int getLocalQueueBrowserPrefetch() {
        return this.localPrefetchPolicy.getQueueBrowserPrefetch();
    }

    public void setLocalQueueBrowserPrefetch(int queueBrowserPrefetch) {
        this.localPrefetchPolicy.setQueueBrowserPrefetch(queueBrowserPrefetch);
    }

    public int getLocalTopicPrefetch() {
        return this.localPrefetchPolicy.getTopicPrefetch();
    }

    public void setLocalTopicPrefetch(int topicPrefetch) {
        this.localPrefetchPolicy.setTopicPrefetch(topicPrefetch);
    }

    public int getRemoteDurableTopicPrefetch() {
        return this.remotePrefetchPolicy.getDurableTopicPrefetch();
    }

    public void setRemoteDurableTopicPrefetch(int durableTopicPrefetch) {
        this.remotePrefetchPolicy.setDurableTopicPrefetch(durableTopicPrefetch);
    }

    public int getRemoteQueuePrefetch() {
        return this.remotePrefetchPolicy.getQueuePrefetch();
    }

    public void setRemoteQueuePrefetch(int queuePrefetch) {
        this.remotePrefetchPolicy.setQueuePrefetch(queuePrefetch);
    }

    public int getRemoteQueueBrowserPrefetch() {
        return this.remotePrefetchPolicy.getQueueBrowserPrefetch();
    }

    public void setRemoteQueueBrowserPrefetch(int queueBrowserPrefetch) {
        this.remotePrefetchPolicy.setQueueBrowserPrefetch(queueBrowserPrefetch);
    }

    public int getRemoteTopicPrefetch() {
        return this.remotePrefetchPolicy.getTopicPrefetch();
    }

    public void setRemoteTopicPrefetch(int topicPrefetch) {
        this.remotePrefetchPolicy.setTopicPrefetch(topicPrefetch);
    }

    protected NetworkChannel createNetworkChannel(String url) {
        NetworkChannel answer = new NetworkChannel(this, this.getBrokerContainer(), url);
        answer.setRemoteUserName(this.getRemoteUserName());
        answer.setRemotePassword(this.getRemotePassword());
        return answer;
    }

    protected void configure(NetworkChannel networkChannel) throws JMSException {
        networkChannel.setLocalPrefetchPolicy(this.localPrefetchPolicy);
        networkChannel.setRemotePrefetchPolicy(this.remotePrefetchPolicy);
    }
}

