/*
 * Decompiled with CFR 0.152.
 */
package org.activemq;

import java.util.Iterator;
import java.util.List;
import javax.jms.JMSException;
import org.activemq.ActiveMQConnection;
import org.activemq.ActiveMQMessageConsumer;
import org.activemq.ActiveMQSession;
import org.activemq.MessageDispatchChannel;
import org.activemq.command.ConsumerId;
import org.activemq.command.MessageDispatch;
import org.activemq.thread.Task;
import org.activemq.thread.TaskRunner;
import org.activemq.util.JMSExceptionSupport;

public class ActiveMQSessionExecutor
implements Task {
    private ActiveMQSession session;
    private MessageDispatchChannel messageQueue = new MessageDispatchChannel();
    private boolean dispatchedBySessionPool;
    private TaskRunner taskRunner;

    ActiveMQSessionExecutor(ActiveMQSession session) {
        this.session = session;
    }

    void setDispatchedBySessionPool(boolean value) {
        this.dispatchedBySessionPool = value;
        this.wakeup();
    }

    void execute(MessageDispatch message) throws InterruptedException {
        if (this.session.connection.isDispatchOptimizedMessage() && !this.dispatchedBySessionPool) {
            this.dispatch(message);
        } else {
            this.messageQueue.enqueue(message);
            this.wakeup();
        }
    }

    private void wakeup() {
        if (!this.dispatchedBySessionPool && !this.messageQueue.isClosed() && this.messageQueue.isRunning() && !this.messageQueue.isEmpty()) {
            try {
                this.taskRunner.wakeup();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void executeFirst(MessageDispatch message) {
        this.messageQueue.enqueueFirst(message);
        this.wakeup();
    }

    boolean hasUncomsumedMessages() {
        return !this.messageQueue.isEmpty();
    }

    public void run() {
    }

    void dispatch(MessageDispatch message) {
        Iterator i = this.session.consumers.iterator();
        while (i.hasNext()) {
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)i.next();
            ConsumerId consumerId = message.getConsumerId();
            if (!consumerId.equals(consumer.getConsumerId())) continue;
            consumer.dispatch(message);
        }
    }

    synchronized void start() {
        if (!this.messageQueue.isRunning()) {
            this.messageQueue.start();
            this.taskRunner = ActiveMQConnection.SESSION_TASK_RUNNER.createTaskRunner(this);
            this.wakeup();
        }
    }

    void stop() throws JMSException {
        try {
            if (this.messageQueue.isRunning()) {
                this.messageQueue.stop();
                this.taskRunner.shutdown();
            }
        }
        catch (InterruptedException e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    boolean isRunning() {
        return this.messageQueue.isRunning();
    }

    void close() {
        this.messageQueue.close();
    }

    void clear() {
        this.messageQueue.clear();
    }

    MessageDispatch dequeueNoWait() {
        try {
            return this.messageQueue.dequeue(0L);
        }
        catch (InterruptedException ie) {
            return null;
        }
    }

    protected void clearMessagesInProgress() {
        this.messageQueue.clear();
    }

    public boolean isEmpty() {
        return this.messageQueue.isEmpty();
    }

    public boolean iterate() {
        if (this.messageQueue.peek() == null) {
            return false;
        }
        this.dispatch(this.messageQueue.dequeueNoWait());
        return true;
    }

    List getUnconsumedMessages() {
        return this.messageQueue.removeAll();
    }
}

