/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.advisory;

import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQTopic;

public class AdvisorySupport {
    public static final String ADVISORY_TOPIC_PREFIX = "ActiveMQ.Advisory.";
    public static final ActiveMQTopic CONNECTION_ADVISORY_TOPIC = new ActiveMQTopic("ActiveMQ.Advisory.Connection");
    public static final ActiveMQTopic QUEUE_ADVISORY_TOPIC = new ActiveMQTopic("ActiveMQ.Advisory.Queue");
    public static final ActiveMQTopic TOPIC_ADVISORY_TOPIC = new ActiveMQTopic("ActiveMQ.Advisory.Topic");
    public static final ActiveMQTopic TEMP_QUEUE_ADVISORY_TOPIC = new ActiveMQTopic("ActiveMQ.Advisory.TempQueue");
    public static final ActiveMQTopic TEMP_TOPIC_ADVISORY_TOPIC = new ActiveMQTopic("ActiveMQ.Advisory.TempTopic");
    public static final String PRODUCER_ADVISORY_TOPIC_PREFIX = "ActiveMQ.Advisory.Producer.";
    public static final String CONSUMER_ADVISORY_TOPIC_PREFIX = "ActiveMQ.Advisory.Consumer.";
    public static final ActiveMQTopic TEMP_DESTINATION_COMPOSITE_ADVISORY_TOPIC = new ActiveMQTopic(TEMP_QUEUE_ADVISORY_TOPIC + "," + TEMP_TOPIC_ADVISORY_TOPIC);

    public static ActiveMQTopic getConnectionAdvisoryTopic() {
        return CONNECTION_ADVISORY_TOPIC;
    }

    public static ActiveMQTopic getConsumerAdvisoryTopic(ActiveMQDestination destination) {
        String name = CONSUMER_ADVISORY_TOPIC_PREFIX + destination.getQualifiedName();
        return new ActiveMQTopic(name);
    }

    public static ActiveMQTopic getProducerAdvisoryTopic(ActiveMQDestination destination) {
        String name = PRODUCER_ADVISORY_TOPIC_PREFIX + destination.getQualifiedName();
        return new ActiveMQTopic(name);
    }

    public static ActiveMQTopic getDestinationAdvisoryTopic(ActiveMQDestination destination) {
        switch (destination.getDestinationType()) {
            case 1: {
                return QUEUE_ADVISORY_TOPIC;
            }
            case 2: {
                return TOPIC_ADVISORY_TOPIC;
            }
            case 5: {
                return TEMP_QUEUE_ADVISORY_TOPIC;
            }
            case 6: {
                return TEMP_TOPIC_ADVISORY_TOPIC;
            }
        }
        throw new RuntimeException("Unknown destination type: " + destination.getDestinationType());
    }

    public static boolean isDestinationAdvisoryTopic(ActiveMQDestination destination) {
        if (destination.isComposite()) {
            ActiveMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isDestinationAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.equals(TEMP_QUEUE_ADVISORY_TOPIC) || destination.equals(TEMP_TOPIC_ADVISORY_TOPIC) || destination.equals(QUEUE_ADVISORY_TOPIC) || destination.equals(TOPIC_ADVISORY_TOPIC);
    }

    public static boolean isAdvisoryTopic(ActiveMQDestination destination) {
        if (destination.isComposite()) {
            ActiveMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(ADVISORY_TOPIC_PREFIX);
    }

    public static boolean isConnectionAdvisoryTopic(ActiveMQDestination destination) {
        if (destination.isComposite()) {
            ActiveMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isConnectionAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.equals(CONNECTION_ADVISORY_TOPIC);
    }

    public static boolean isProducerAdvisoryTopic(ActiveMQDestination destination) {
        if (destination.isComposite()) {
            ActiveMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isProducerAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(PRODUCER_ADVISORY_TOPIC_PREFIX);
    }

    public static boolean isConsumerAdvisoryTopic(ActiveMQDestination destination) {
        if (destination.isComposite()) {
            ActiveMQDestination[] compositeDestinations = destination.getCompositeDestinations();
            for (int i = 0; i < compositeDestinations.length; ++i) {
                if (!AdvisorySupport.isConsumerAdvisoryTopic(compositeDestinations[i])) continue;
                return true;
            }
            return false;
        }
        return destination.isTopic() && destination.getPhysicalName().startsWith(CONSUMER_ADVISORY_TOPIC_PREFIX);
    }
}

