/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import org.activemq.broker.Broker;
import org.activemq.broker.BrokerFilter;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.Message;
import org.activemq.command.ProducerInfo;

public class CompositeDestinationBroker
extends BrokerFilter {
    public CompositeDestinationBroker(Broker next) {
        super(next);
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Throwable {
        ActiveMQDestination destination = info.getDestination();
        if (destination != null && destination.isComposite()) {
            ActiveMQDestination[] destinations = destination.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ProducerInfo copy = info.copy();
                copy.setDestination(destinations[i]);
                this.next.addProducer(context, copy);
            }
        } else {
            this.next.addProducer(context, info);
        }
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Throwable {
        ActiveMQDestination destination = info.getDestination();
        if (destination != null && destination.isComposite()) {
            ActiveMQDestination[] destinations = destination.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ProducerInfo copy = info.copy();
                copy.setDestination(destinations[i]);
                this.next.removeProducer(context, copy);
            }
        } else {
            this.next.removeProducer(context, info);
        }
    }

    public void send(ConnectionContext context, Message messageSend) throws Throwable {
        ActiveMQDestination destination = messageSend.getDestination();
        if (destination.isComposite()) {
            ActiveMQDestination[] destinations = destination.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                if (i != 0) {
                    messageSend = messageSend.copy();
                }
                messageSend.setDestination(destinations[i]);
                this.next.send(context, messageSend);
            }
        } else {
            this.next.send(context, messageSend);
        }
    }
}

