/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.jmx;

import org.activemq.broker.Broker;
import org.activemq.broker.jmx.BrokerViewMBean;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.memory.UsageManager;

public class BrokerView
implements BrokerViewMBean {
    private final Broker broker;
    private final DestinationStatistics destinationStatistics;
    private final UsageManager usageManager;

    public BrokerView(Broker broker, DestinationStatistics destinationStatistics, UsageManager usageManager) {
        this.broker = broker;
        this.destinationStatistics = destinationStatistics;
        this.usageManager = usageManager;
    }

    public String getBrokerId() {
        return this.broker.getBrokerId().toString();
    }

    public void gc() {
        this.broker.gc();
    }

    public void start() throws Exception {
        this.broker.start();
    }

    public void stop() throws Exception {
        this.broker.stop();
    }

    public long getTotalEnqueueCount() {
        return this.destinationStatistics.getEnqueues().getCount();
    }

    public long getTotalDequeueCount() {
        return this.destinationStatistics.getDequeues().getCount();
    }

    public long getTotalConsumerCount() {
        return this.destinationStatistics.getConsumers().getCount();
    }

    public long getTotalMessages() {
        return this.destinationStatistics.getMessages().getCount();
    }

    public long getTotalMessagesCached() {
        return this.destinationStatistics.getMessagesCached().getCount();
    }

    public int getMemoryPercentageUsed() {
        return this.usageManager.getPercentUsage();
    }

    public long getMemoryLimit() {
        return this.usageManager.getLimit();
    }

    public void setMemoryLimit(long limit) {
        this.usageManager.setLimit(limit);
    }

    public void resetStatistics() {
        this.destinationStatistics.reset();
    }
}

