/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.jmx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.registry.LocateRegistry;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.activemq.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagementContext
implements Service {
    public static final String DEFAULT_DOMAIN = "org.activemq";
    private static final Log log = LogFactory.getLog((Class)ManagementContext.class);
    private MBeanServer beanServer;
    private String jmxDomainName = "org.activemq";
    private boolean useMBeanServer = true;
    private boolean createMBeanServer = true;
    private boolean locallyCreateMBeanServer = false;
    private boolean createConnector = true;
    private int connectorPort = 1099;
    private String connectorPath = "/jmxconnector";
    private JMXConnectorServer connectorServer;
    private ObjectName namingServiceObjectName;

    public ManagementContext() {
        this(null);
    }

    public ManagementContext(MBeanServer server) {
        this.beanServer = server;
    }

    public void start() throws IOException {
        this.getMBeanServer();
        if (this.connectorServer != null) {
            try {
                this.getMBeanServer().invoke(this.namingServiceObjectName, "start", null, null);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                this.connectorServer.start();
                log.info((Object)("JMX consoles can connect to " + this.connectorServer.getAddress()));
            }
            catch (IOException e) {
                log.warn((Object)("Failed to start jmx connector: " + e.getMessage()));
            }
        }
    }

    public void stop() throws IOException {
        ArrayList<MBeanServer> list;
        if (this.connectorServer != null) {
            try {
                this.connectorServer.stop();
            }
            catch (IOException e) {
                log.warn((Object)("Failed to stop jmx connector: " + e.getMessage()));
            }
            this.connectorServer = null;
            try {
                this.getMBeanServer().invoke(this.namingServiceObjectName, "stop", null, null);
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        if (this.locallyCreateMBeanServer && this.beanServer != null && (list = MBeanServerFactory.findMBeanServer(null)) != null && !list.isEmpty() && list.contains(this.beanServer)) {
            MBeanServerFactory.releaseMBeanServer(this.beanServer);
        }
    }

    public String getJmxDomainName() {
        return this.jmxDomainName;
    }

    public void setJmxDomainName(String jmxDomainName) {
        this.jmxDomainName = jmxDomainName;
    }

    public MBeanServer getMBeanServer() {
        if (this.beanServer == null) {
            this.beanServer = this.findMBeanServer();
        }
        return this.beanServer;
    }

    public boolean isUseMBeanServer() {
        return this.useMBeanServer;
    }

    public void setUseMBeanServer(boolean useMBeanServer) {
        this.useMBeanServer = useMBeanServer;
    }

    public boolean isCreateMBeanServer() {
        return this.createMBeanServer;
    }

    public void setCreateMBeanServer(boolean enableJMX) {
        this.createMBeanServer = enableJMX;
    }

    public ObjectName createCustomComponentMBeanName(String type, String name) {
        ObjectName result = null;
        String tmp = this.jmxDomainName + ":" + "type=" + ManagementContext.sanitizeString(type) + ",name=" + ManagementContext.sanitizeString(name);
        try {
            result = new ObjectName(tmp);
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)("Couldn't create ObjectName from: " + type + " , " + name));
        }
        return result;
    }

    private static String sanitizeString(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
        }
        return result;
    }

    public static ObjectName getSystemObjectName(String domainName, String containerName, Class theClass) throws MalformedObjectNameException, NullPointerException {
        String tmp = domainName + ":" + "type=" + theClass.getName() + ",name=" + ManagementContext.getRelativeName(containerName, theClass);
        return new ObjectName(tmp);
    }

    private static String getRelativeName(String containerName, Class theClass) {
        String name = theClass.getName();
        int index = name.lastIndexOf(".");
        if (index >= 0 && index + 1 < name.length()) {
            name = name.substring(index + 1);
        }
        return containerName + "." + name;
    }

    public void unregisterMBean(ObjectName name) throws JMException {
        if (this.beanServer != null && this.beanServer.isRegistered(name)) {
            this.beanServer.unregisterMBean(name);
        }
    }

    protected synchronized MBeanServer findMBeanServer() {
        MBeanServer result = null;
        try {
            ArrayList<MBeanServer> list;
            if (this.useMBeanServer && (list = MBeanServerFactory.findMBeanServer(null)) != null && list.size() > 0) {
                result = (MBeanServer)list.get(0);
            }
            if (result == null && this.createMBeanServer) {
                result = this.createMBeanServer();
            }
        }
        catch (NoClassDefFoundError e) {
            log.error((Object)"Couldnot load MBeanServer", (Throwable)e);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to initialize MBeanServer", e);
        }
        return result;
    }

    protected MBeanServer createMBeanServer() throws MalformedObjectNameException, IOException {
        MBeanServer mbeanServer = MBeanServerFactory.createMBeanServer(this.jmxDomainName);
        this.locallyCreateMBeanServer = true;
        if (this.createConnector) {
            this.createConnector(mbeanServer);
        }
        return mbeanServer;
    }

    private void createConnector(MBeanServer mbeanServer) throws MalformedObjectNameException, MalformedURLException, IOException {
        try {
            LocateRegistry.createRegistry(this.connectorPort);
            this.namingServiceObjectName = ObjectName.getInstance("naming:type=rmiregistry");
            mbeanServer.createMBean("mx4j.tools.naming.NamingService", this.namingServiceObjectName, null);
            Attribute attr = new Attribute("Port", new Integer(this.connectorPort));
            mbeanServer.setAttribute(this.namingServiceObjectName, attr);
        }
        catch (Throwable e) {
            log.debug((Object)"Failed to create local registry", e);
        }
        String serviceURL = "service:jmx:rmi:///jndi/rmi://localhost:" + this.connectorPort + this.connectorPath;
        JMXServiceURL url = new JMXServiceURL(serviceURL);
        this.connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mbeanServer);
    }

    public String getConnectorPath() {
        return this.connectorPath;
    }

    public void setConnectorPath(String connectorPath) {
        this.connectorPath = connectorPath;
    }

    public int getConnectorPort() {
        return this.connectorPort;
    }

    public void setConnectorPort(int connectorPort) {
        this.connectorPort = connectorPort;
    }

    public boolean isCreateConnector() {
        return this.createConnector;
    }

    public void setCreateConnector(boolean createConnector) {
        this.createConnector = createConnector;
    }
}

