/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import java.io.IOException;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.Subscription;
import org.activemq.command.ActiveMQMessage;
import org.activemq.command.ConsumerId;
import org.activemq.command.Message;
import org.activemq.command.MessageId;

public class IndirectMessageReference
implements MessageReference {
    public static final ActiveMQMessage END_OF_BROWSE_MARKER_MESSAGE;
    public static final IndirectMessageReference END_OF_BROWSE_MARKER;
    private final Destination regionDestination;
    private final MessageId messageId;
    private final boolean persistent;
    private final String groupID;
    private final int groupSequence;
    private final ConsumerId targetConsumerId;
    private short redeliveryCounter = 0;
    private Subscription lockOwner;
    private boolean dropped;
    private boolean acked;
    private Message message;
    private int referenceCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    private IndirectMessageReference(ActiveMQMessage message) {
        this.regionDestination = null;
        this.message = message;
        this.messageId = null;
        this.persistent = false;
        this.groupID = null;
        this.groupSequence = 0;
        this.targetConsumerId = null;
    }

    public IndirectMessageReference(Destination destination, Message message) {
        this.regionDestination = destination;
        this.message = message;
        this.messageId = message.getMessageId();
        this.persistent = message.isPersistent() && destination.getMessageStore() != null;
        this.groupID = message.getGroupID();
        this.groupSequence = message.getGroupSequence();
        this.targetConsumerId = message.getTargetConsumerId();
        this.referenceCount = 1;
        message.incrementReferenceCount();
    }

    public synchronized Message getMessageHardRef() {
        return this.message;
    }

    public synchronized int getReferenceCount() {
        return this.referenceCount;
    }

    public synchronized int incrementReferenceCount() {
        int rc = ++this.referenceCount;
        if (this.persistent && rc == 1) {
            if (!$assertionsDisabled && this.message != null) {
                throw new AssertionError();
            }
            try {
                this.message = this.regionDestination.loadMessage(this.messageId);
                if (this.message == null) {
                    this.dropped = true;
                } else {
                    this.message.incrementReferenceCount();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return rc;
    }

    public synchronized int decrementReferenceCount() {
        int rc = --this.referenceCount;
        if (this.persistent && rc == 0 && this.message != null) {
            this.message.decrementReferenceCount();
            this.message = null;
        }
        return rc;
    }

    public synchronized Message getMessage() {
        return this.message;
    }

    public String toString() {
        return "Message " + this.messageId + " dropped=" + this.dropped + " locked=" + (this.lockOwner != null);
    }

    public synchronized void incrementRedeliveryCounter() {
        this.redeliveryCounter = (short)(this.redeliveryCounter + 1);
    }

    public synchronized boolean isDropped() {
        return this.dropped;
    }

    public synchronized void drop() {
        this.dropped = true;
        if (!this.persistent && this.message != null) {
            this.message.decrementReferenceCount();
            this.message = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock(Subscription subscription) {
        if (!this.regionDestination.lock(this, subscription)) {
            return false;
        }
        IndirectMessageReference indirectMessageReference = this;
        synchronized (indirectMessageReference) {
            if (this.lockOwner != null && this.lockOwner != subscription) {
                return false;
            }
            this.lockOwner = subscription;
            return true;
        }
    }

    public synchronized void unlock() {
        this.lockOwner = null;
    }

    public synchronized Subscription getLockOwner() {
        return this.lockOwner;
    }

    public synchronized int getRedeliveryCounter() {
        return this.redeliveryCounter;
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public Destination getRegionDestination() {
        return this.regionDestination;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public synchronized boolean isLocked() {
        return this.lockOwner != null;
    }

    public synchronized boolean isAcked() {
        return this.acked;
    }

    public synchronized void setAcked(boolean b) {
        this.acked = b;
    }

    public String getGroupID() {
        return this.groupID;
    }

    public int getGroupSequence() {
        return this.groupSequence;
    }

    public ConsumerId getTargetConsumerId() {
        return this.targetConsumerId;
    }

    static {
        $assertionsDisabled = !IndirectMessageReference.class.desiredAssertionStatus();
        END_OF_BROWSE_MARKER_MESSAGE = new ActiveMQMessage();
        END_OF_BROWSE_MARKER = new IndirectMessageReference(END_OF_BROWSE_MARKER_MESSAGE);
    }
}

