/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.AbstractRegion;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.broker.region.Queue;
import org.activemq.broker.region.QueueBrowserSubscription;
import org.activemq.broker.region.QueueSubscription;
import org.activemq.broker.region.Subscription;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.ActiveMQTempDestination;
import org.activemq.command.ConsumerInfo;
import org.activemq.memory.UsageManager;
import org.activemq.thread.TaskRunnerFactory;

public class TempQueueRegion
extends AbstractRegion {
    public TempQueueRegion(DestinationStatistics destinationStatistics, UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        super(destinationStatistics, memoryManager, taskRunnerFactory, null);
        this.setAutoCreateDestinations(false);
    }

    protected Destination createDestination(ActiveMQDestination destination) throws Throwable {
        final ActiveMQTempDestination tempDest = (ActiveMQTempDestination)destination;
        return new Queue(destination, this.memoryManager, null, this.destinationStatistics, this.taskRunnerFactory){

            public void addSubscription(ConnectionContext context, Subscription sub) throws Throwable {
                if (!tempDest.getConnectionId().equals(sub.getConsumerInfo().getConsumerId().getConnectionId())) {
                    throw new JMSException("Cannot subscribe to remote temporary destination: " + tempDest);
                }
                super.addSubscription(context, sub);
            }
        };
    }

    protected Subscription createSubscription(ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        if (info.isBrowser()) {
            return new QueueBrowserSubscription(context, info);
        }
        return new QueueSubscription(context, info);
    }

    public String toString() {
        return "TempQueueRegion: destinations=" + this.destinations.size() + ", subscriptions=" + this.subscriptions.size() + ", memory=" + this.memoryManager.getPercentUsage() + "%";
    }
}

