/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region.policy;

import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.MessageReference;
import org.activemq.broker.region.Subscription;
import org.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.activemq.filter.MessageEvaluationContext;

public class LastImageSubscriptionRecoveryPolicy
implements SubscriptionRecoveryPolicy {
    private volatile MessageReference lastImage;

    public void add(ConnectionContext context, MessageReference node) throws Throwable {
        this.lastImage = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover(ConnectionContext context, Subscription sub) throws Throwable {
        MessageReference node = this.lastImage;
        if (node != null) {
            MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
            try {
                msgContext.setDestination(node.getRegionDestination().getActiveMQDestination());
                msgContext.setMessageReference(node);
                if (sub.matches(node, msgContext)) {
                    sub.add(node);
                }
            }
            finally {
                msgContext.clear();
            }
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }
}

