/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import org.activemq.command.Command;

public abstract class BaseCommand
implements Command {
    protected short commandId;
    protected boolean responseRequired;

    public void copy(BaseCommand copy) {
        copy.commandId = this.commandId;
        copy.responseRequired = this.responseRequired;
    }

    public boolean isWireFormatInfo() {
        return false;
    }

    public boolean isBrokerInfo() {
        return false;
    }

    public boolean isResponse() {
        return false;
    }

    public boolean isMessageDispatch() {
        return false;
    }

    public boolean isMessageSend() {
        return false;
    }

    public boolean isMarshallAware() {
        return false;
    }

    public short getCommandId() {
        return this.commandId;
    }

    public void setCommandId(short commandId) {
        this.commandId = commandId;
    }

    public boolean isResponseRequired() {
        return this.responseRequired;
    }

    public void setResponseRequired(boolean responseRequired) {
        this.responseRequired = responseRequired;
    }

    public String toString() {
        LinkedHashMap map = new LinkedHashMap();
        this.addFields(map, this.getClass());
        return BaseCommand.simpleName(this.getClass()) + " " + map;
    }

    public static String simpleName(Class clazz) {
        String name = clazz.getName();
        int p = name.lastIndexOf(".");
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        return name;
    }

    private void addFields(LinkedHashMap map, Class clazz) {
        if (clazz != BaseCommand.class) {
            this.addFields(map, clazz.getSuperclass());
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) continue;
            try {
                map.put(field.getName(), field.get(this));
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

