/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.memory;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.activemq.memory.CacheEvictor;
import org.activemq.memory.UsageListener;
import org.activemq.memory.UsageManager;
import org.activemq.thread.Task;
import org.activemq.thread.TaskRunner;
import org.activemq.thread.TaskRunnerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheEvictionUsageListener
implements UsageListener {
    private static final Log log = LogFactory.getLog((Class)CacheEvictionUsageListener.class);
    private final CopyOnWriteArrayList evictors = new CopyOnWriteArrayList();
    private final int usageHighMark;
    private final int usageLowMark;
    private final TaskRunner evictionTask;
    private final UsageManager usageManager;

    public CacheEvictionUsageListener(UsageManager usageManager, int usageHighMark, int usageLowMark, TaskRunnerFactory taskRunnerFactory) {
        this.usageManager = usageManager;
        this.usageHighMark = usageHighMark;
        this.usageLowMark = usageLowMark;
        this.evictionTask = taskRunnerFactory.createTaskRunner(new Task(){

            public boolean iterate() {
                return CacheEvictionUsageListener.this.evictMessages();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evictMessages() {
        log.debug((Object)("Evicting cache memory usage: " + this.usageManager.getPercentUsage()));
        LinkedList list = new LinkedList(this.evictors);
        while (list.size() > 0 && this.usageManager.getPercentUsage() > this.usageLowMark) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                CacheEvictor evictor = (CacheEvictor)iter.next();
                if (evictor.evictCacheEntry() != null) continue;
                iter.remove();
            }
        }
        return false;
    }

    public void onMemoryUseChanged(UsageManager memoryManager, int oldPercentUsage, int newPercentUsage) {
        if (oldPercentUsage < newPercentUsage && memoryManager.getPercentUsage() >= this.usageHighMark) {
            try {
                this.evictionTask.wakeup();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void add(CacheEvictor evictor) {
        this.evictors.add((Object)evictor);
    }

    public void remove(CacheEvictor evictor) {
        this.evictors.remove((Object)evictor);
    }
}

