/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.BaseCommand;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public abstract class BaseCommandMarshaller
extends DataStreamMarshaller {
    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        BaseCommand info = (BaseCommand)o;
        info.setCommandId(dataIn.readShort());
        info.setResponseRequired(bs.readBoolean());
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        BaseCommand info = (BaseCommand)o;
        int rc = super.marshal1(wireFormat, o, bs);
        bs.writeBoolean(info.isResponseRequired());
        return rc + 2;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        BaseCommand info = (BaseCommand)o;
        dataOut.writeShort(info.getCommandId());
        bs.readBoolean();
    }
}

