/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.BrokerId;
import org.activemq.command.BrokerInfo;
import org.activemq.command.DataStructure;
import org.activemq.command.RedeliveryPolicy;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.BaseCommandMarshaller;

public class BrokerInfoMarshaller
extends BaseCommandMarshaller {
    public byte getDataStructureType() {
        return 2;
    }

    public DataStructure createObject() {
        return new BrokerInfo();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        BrokerInfo info = (BrokerInfo)o;
        info.setBrokerId((BrokerId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setBrokerURL(this.readString(dataIn, bs));
        if (bs.readBoolean()) {
            int size = dataIn.readShort();
            BrokerInfo[] value = new BrokerInfo[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (BrokerInfo)this.unmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setPeerBrokerInfos(value);
        } else {
            info.setPeerBrokerInfos(null);
        }
        info.setRedeliveryPolicy((RedeliveryPolicy)this.unmarsalNestedObject(wireFormat, dataIn, bs));
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        BrokerInfo info = (BrokerInfo)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1CachedObject(wireFormat, info.getBrokerId(), bs);
        rc += this.writeString(info.getBrokerURL(), bs);
        rc += this.marshalObjectArray(wireFormat, info.getPeerBrokerInfos(), bs);
        return (rc += this.marshal1NestedObject(wireFormat, info.getRedeliveryPolicy(), bs)) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        BrokerInfo info = (BrokerInfo)o;
        this.marshal2CachedObject(wireFormat, info.getBrokerId(), dataOut, bs);
        this.writeString(info.getBrokerURL(), dataOut, bs);
        this.marshalObjectArray(wireFormat, info.getPeerBrokerInfos(), dataOut, bs);
        this.marshal2NestedObject(wireFormat, info.getRedeliveryPolicy(), dataOut, bs);
    }
}

