/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.DataStructure;
import org.activemq.command.JournalTopicAck;
import org.activemq.command.MessageId;
import org.activemq.command.TransactionId;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class JournalTopicAckMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 50;
    }

    public DataStructure createObject() {
        return new JournalTopicAck();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        JournalTopicAck info = (JournalTopicAck)o;
        info.setDestination((ActiveMQDestination)this.unmarsalNestedObject(wireFormat, dataIn, bs));
        info.setMessageId((MessageId)this.unmarsalNestedObject(wireFormat, dataIn, bs));
        info.setMessageSequenceId(bs.readBoolean() ? dataIn.readLong() : 0L);
        info.setSubscritionName(this.readString(dataIn, bs));
        info.setClientId(this.readString(dataIn, bs));
        info.setTransactionId((TransactionId)this.unmarsalNestedObject(wireFormat, dataIn, bs));
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        JournalTopicAck info = (JournalTopicAck)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1NestedObject(wireFormat, info.getDestination(), bs);
        rc += this.marshal1NestedObject(wireFormat, info.getMessageId(), bs);
        bs.writeBoolean(info.getMessageSequenceId() != 0L);
        rc += info.getMessageSequenceId() != 0L ? 8 : 0;
        rc += this.writeString(info.getSubscritionName(), bs);
        rc += this.writeString(info.getClientId(), bs);
        return (rc += this.marshal1NestedObject(wireFormat, info.getTransactionId(), bs)) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        JournalTopicAck info = (JournalTopicAck)o;
        this.marshal2NestedObject(wireFormat, info.getDestination(), dataOut, bs);
        this.marshal2NestedObject(wireFormat, info.getMessageId(), dataOut, bs);
        if (bs.readBoolean()) {
            dataOut.writeLong(info.getMessageSequenceId());
        }
        this.writeString(info.getSubscritionName(), dataOut, bs);
        this.writeString(info.getClientId(), dataOut, bs);
        this.marshal2NestedObject(wireFormat, info.getTransactionId(), dataOut, bs);
    }
}

