/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.ActiveMQBytesMessageMarshaller;
import org.activemq.openwire.v1.ActiveMQMapMessageMarshaller;
import org.activemq.openwire.v1.ActiveMQMessageMarshaller;
import org.activemq.openwire.v1.ActiveMQObjectMessageMarshaller;
import org.activemq.openwire.v1.ActiveMQQueueMarshaller;
import org.activemq.openwire.v1.ActiveMQStreamMessageMarshaller;
import org.activemq.openwire.v1.ActiveMQTempQueueMarshaller;
import org.activemq.openwire.v1.ActiveMQTempTopicMarshaller;
import org.activemq.openwire.v1.ActiveMQTextMessageMarshaller;
import org.activemq.openwire.v1.ActiveMQTopicMarshaller;
import org.activemq.openwire.v1.BrokerIdMarshaller;
import org.activemq.openwire.v1.BrokerInfoMarshaller;
import org.activemq.openwire.v1.ConnectionIdMarshaller;
import org.activemq.openwire.v1.ConnectionInfoMarshaller;
import org.activemq.openwire.v1.ConsumerIdMarshaller;
import org.activemq.openwire.v1.ConsumerInfoMarshaller;
import org.activemq.openwire.v1.ControlCommandMarshaller;
import org.activemq.openwire.v1.DataArrayResponseMarshaller;
import org.activemq.openwire.v1.DataResponseMarshaller;
import org.activemq.openwire.v1.DestinationInfoMarshaller;
import org.activemq.openwire.v1.ExceptionResponseMarshaller;
import org.activemq.openwire.v1.IntegerResponseMarshaller;
import org.activemq.openwire.v1.JournalQueueAckMarshaller;
import org.activemq.openwire.v1.JournalTopicAckMarshaller;
import org.activemq.openwire.v1.JournalTraceMarshaller;
import org.activemq.openwire.v1.JournalTransactionMarshaller;
import org.activemq.openwire.v1.KeepAliveInfoMarshaller;
import org.activemq.openwire.v1.LocalTransactionIdMarshaller;
import org.activemq.openwire.v1.MessageAckMarshaller;
import org.activemq.openwire.v1.MessageDispatchMarshaller;
import org.activemq.openwire.v1.MessageIdMarshaller;
import org.activemq.openwire.v1.ProducerIdMarshaller;
import org.activemq.openwire.v1.ProducerInfoMarshaller;
import org.activemq.openwire.v1.RedeliveryPolicyMarshaller;
import org.activemq.openwire.v1.RemoveInfoMarshaller;
import org.activemq.openwire.v1.RemoveSubscriptionInfoMarshaller;
import org.activemq.openwire.v1.ResponseMarshaller;
import org.activemq.openwire.v1.SessionIdMarshaller;
import org.activemq.openwire.v1.SessionInfoMarshaller;
import org.activemq.openwire.v1.ShutdownInfoMarshaller;
import org.activemq.openwire.v1.SubscriptionInfoMarshaller;
import org.activemq.openwire.v1.TransactionInfoMarshaller;
import org.activemq.openwire.v1.WireFormatInfoMarshaller;
import org.activemq.openwire.v1.XATransactionIdMarshaller;

public class MarshallerFactory {
    private static final DataStreamMarshaller[] marshaller = new DataStreamMarshaller[256];

    private static void add(DataStreamMarshaller dsm) {
        MarshallerFactory.marshaller[dsm.getDataStructureType()] = dsm;
    }

    public static DataStreamMarshaller[] createMarshallerMap(OpenWireFormat wireFormat) {
        return marshaller;
    }

    static {
        MarshallerFactory.add(new ActiveMQMessageMarshaller());
        MarshallerFactory.add(new MessageIdMarshaller());
        MarshallerFactory.add(new ControlCommandMarshaller());
        MarshallerFactory.add(new IntegerResponseMarshaller());
        MarshallerFactory.add(new RemoveSubscriptionInfoMarshaller());
        MarshallerFactory.add(new SubscriptionInfoMarshaller());
        MarshallerFactory.add(new DataArrayResponseMarshaller());
        MarshallerFactory.add(new ConnectionIdMarshaller());
        MarshallerFactory.add(new BrokerInfoMarshaller());
        MarshallerFactory.add(new JournalTraceMarshaller());
        MarshallerFactory.add(new MessageDispatchMarshaller());
        MarshallerFactory.add(new KeepAliveInfoMarshaller());
        MarshallerFactory.add(new ActiveMQStreamMessageMarshaller());
        MarshallerFactory.add(new JournalQueueAckMarshaller());
        MarshallerFactory.add(new ActiveMQTempTopicMarshaller());
        MarshallerFactory.add(new ProducerInfoMarshaller());
        MarshallerFactory.add(new BrokerIdMarshaller());
        MarshallerFactory.add(new MessageAckMarshaller());
        MarshallerFactory.add(new ActiveMQBytesMessageMarshaller());
        MarshallerFactory.add(new SessionInfoMarshaller());
        MarshallerFactory.add(new ActiveMQTextMessageMarshaller());
        MarshallerFactory.add(new ActiveMQMapMessageMarshaller());
        MarshallerFactory.add(new ShutdownInfoMarshaller());
        MarshallerFactory.add(new DataResponseMarshaller());
        MarshallerFactory.add(new JournalTopicAckMarshaller());
        MarshallerFactory.add(new DestinationInfoMarshaller());
        MarshallerFactory.add(new XATransactionIdMarshaller());
        MarshallerFactory.add(new ActiveMQObjectMessageMarshaller());
        MarshallerFactory.add(new SessionIdMarshaller());
        MarshallerFactory.add(new ConsumerIdMarshaller());
        MarshallerFactory.add(new ConsumerInfoMarshaller());
        MarshallerFactory.add(new ConnectionInfoMarshaller());
        MarshallerFactory.add(new ActiveMQTopicMarshaller());
        MarshallerFactory.add(new RedeliveryPolicyMarshaller());
        MarshallerFactory.add(new ExceptionResponseMarshaller());
        MarshallerFactory.add(new JournalTransactionMarshaller());
        MarshallerFactory.add(new ProducerIdMarshaller());
        MarshallerFactory.add(new ActiveMQQueueMarshaller());
        MarshallerFactory.add(new ActiveMQTempQueueMarshaller());
        MarshallerFactory.add(new TransactionInfoMarshaller());
        MarshallerFactory.add(new ResponseMarshaller());
        MarshallerFactory.add(new RemoveInfoMarshaller());
        MarshallerFactory.add(new WireFormatInfoMarshaller());
        MarshallerFactory.add(new LocalTransactionIdMarshaller());
    }
}

