/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activeio.ByteSequence;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.BrokerId;
import org.activemq.command.ConsumerId;
import org.activemq.command.Message;
import org.activemq.command.MessageId;
import org.activemq.command.ProducerId;
import org.activemq.command.TransactionId;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.openwire.v1.BaseCommandMarshaller;

public abstract class MessageMarshaller
extends BaseCommandMarshaller {
    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        byte[] data;
        int size;
        super.unmarshal(wireFormat, o, dataIn, bs);
        Message info = (Message)o;
        info.beforeUnmarshall(wireFormat);
        info.setProducerId((ProducerId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setDestination((ActiveMQDestination)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setTransactionId((TransactionId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setOriginalDestination((ActiveMQDestination)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setMessageId((MessageId)this.unmarsalNestedObject(wireFormat, dataIn, bs));
        info.setOriginalTransactionId((TransactionId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setGroupID(this.readString(dataIn, bs));
        info.setGroupSequence(dataIn.readInt());
        info.setCorrelationId(this.readString(dataIn, bs));
        info.setPersistent(bs.readBoolean());
        info.setExpiration(bs.readBoolean() ? dataIn.readLong() : 0L);
        info.setPriority(dataIn.readByte());
        info.setReplyTo((ActiveMQDestination)this.unmarsalNestedObject(wireFormat, dataIn, bs));
        info.setTimestamp(bs.readBoolean() ? dataIn.readLong() : 0L);
        info.setType(this.readString(dataIn, bs));
        if (bs.readBoolean()) {
            size = dataIn.readInt();
            data = new byte[size];
            dataIn.readFully(data);
            info.setContent(new ByteSequence(data, 0, size));
        } else {
            info.setContent(null);
        }
        if (bs.readBoolean()) {
            size = dataIn.readInt();
            data = new byte[size];
            dataIn.readFully(data);
            info.setMarshalledProperties(new ByteSequence(data, 0, size));
        } else {
            info.setMarshalledProperties(null);
        }
        info.setDataStructure(this.unmarsalNestedObject(wireFormat, dataIn, bs));
        info.setTargetConsumerId((ConsumerId)this.unmarsalCachedObject(wireFormat, dataIn, bs));
        info.setCompressed(bs.readBoolean());
        info.setRedeliveryCounter(dataIn.readInt());
        if (bs.readBoolean()) {
            size = dataIn.readShort();
            BrokerId[] value = new BrokerId[size];
            for (int i = 0; i < size; ++i) {
                value[i] = (BrokerId)this.unmarsalNestedObject(wireFormat, dataIn, bs);
            }
            info.setBrokerPath(value);
        } else {
            info.setBrokerPath(null);
        }
        info.setArrival(bs.readBoolean() ? dataIn.readLong() : 0L);
        info.setUserID(this.readString(dataIn, bs));
        info.afterUnmarshall(wireFormat);
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        Message info = (Message)o;
        info.beforeMarshall(wireFormat);
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.marshal1CachedObject(wireFormat, info.getProducerId(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getDestination(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getTransactionId(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getOriginalDestination(), bs);
        rc += this.marshal1NestedObject(wireFormat, info.getMessageId(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getOriginalTransactionId(), bs);
        rc += this.writeString(info.getGroupID(), bs);
        rc += this.writeString(info.getCorrelationId(), bs);
        bs.writeBoolean(info.isPersistent());
        bs.writeBoolean(info.getExpiration() != 0L);
        rc += info.getExpiration() != 0L ? 8 : 0;
        rc += this.marshal1NestedObject(wireFormat, info.getReplyTo(), bs);
        bs.writeBoolean(info.getTimestamp() != 0L);
        rc += info.getTimestamp() != 0L ? 8 : 0;
        rc += this.writeString(info.getType(), bs);
        bs.writeBoolean(info.getContent() != null);
        rc += info.getContent() == null ? 0 : info.getContent().getLength() + 4;
        bs.writeBoolean(info.getMarshalledProperties() != null);
        rc += info.getMarshalledProperties() == null ? 0 : info.getMarshalledProperties().getLength() + 4;
        rc += this.marshal1NestedObject(wireFormat, info.getDataStructure(), bs);
        rc += this.marshal1CachedObject(wireFormat, info.getTargetConsumerId(), bs);
        bs.writeBoolean(info.isCompressed());
        rc += this.marshalObjectArray(wireFormat, info.getBrokerPath(), bs);
        bs.writeBoolean(info.getArrival() != 0L);
        rc += info.getArrival() != 0L ? 8 : 0;
        return (rc += this.writeString(info.getUserID(), bs)) + 9;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        ByteSequence data;
        super.marshal2(wireFormat, o, dataOut, bs);
        Message info = (Message)o;
        this.marshal2CachedObject(wireFormat, info.getProducerId(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getDestination(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getTransactionId(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getOriginalDestination(), dataOut, bs);
        this.marshal2NestedObject(wireFormat, info.getMessageId(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getOriginalTransactionId(), dataOut, bs);
        this.writeString(info.getGroupID(), dataOut, bs);
        dataOut.writeInt(info.getGroupSequence());
        this.writeString(info.getCorrelationId(), dataOut, bs);
        bs.readBoolean();
        if (bs.readBoolean()) {
            dataOut.writeLong(info.getExpiration());
        }
        dataOut.writeByte(info.getPriority());
        this.marshal2NestedObject(wireFormat, info.getReplyTo(), dataOut, bs);
        if (bs.readBoolean()) {
            dataOut.writeLong(info.getTimestamp());
        }
        this.writeString(info.getType(), dataOut, bs);
        if (bs.readBoolean()) {
            data = info.getContent();
            dataOut.writeInt(data.getLength());
            dataOut.write(data.getData(), data.getOffset(), data.getLength());
        }
        if (bs.readBoolean()) {
            data = info.getMarshalledProperties();
            dataOut.writeInt(data.getLength());
            dataOut.write(data.getData(), data.getOffset(), data.getLength());
        }
        this.marshal2NestedObject(wireFormat, info.getDataStructure(), dataOut, bs);
        this.marshal2CachedObject(wireFormat, info.getTargetConsumerId(), dataOut, bs);
        bs.readBoolean();
        dataOut.writeInt(info.getRedeliveryCounter());
        this.marshalObjectArray(wireFormat, info.getBrokerPath(), dataOut, bs);
        if (bs.readBoolean()) {
            dataOut.writeLong(info.getArrival());
        }
        this.writeString(info.getUserID(), dataOut, bs);
        info.afterMarshall(wireFormat);
    }
}

