/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.openwire.v1;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.activemq.command.DataStructure;
import org.activemq.command.SessionId;
import org.activemq.openwire.BooleanStream;
import org.activemq.openwire.DataStreamMarshaller;
import org.activemq.openwire.OpenWireFormat;

public class SessionIdMarshaller
extends DataStreamMarshaller {
    public byte getDataStructureType() {
        return 121;
    }

    public DataStructure createObject() {
        return new SessionId();
    }

    public void unmarshal(OpenWireFormat wireFormat, Object o, DataInputStream dataIn, BooleanStream bs) throws IOException {
        super.unmarshal(wireFormat, o, dataIn, bs);
        SessionId info = (SessionId)o;
        info.setConnectionId(this.readString(dataIn, bs));
        info.setSessionId(bs.readBoolean() ? dataIn.readLong() : 0L);
    }

    public int marshal1(OpenWireFormat wireFormat, Object o, BooleanStream bs) throws IOException {
        SessionId info = (SessionId)o;
        int rc = super.marshal1(wireFormat, o, bs);
        rc += this.writeString(info.getConnectionId(), bs);
        bs.writeBoolean(info.getSessionId() != 0L);
        return (rc += info.getSessionId() != 0L ? 8 : 0) + 0;
    }

    public void marshal2(OpenWireFormat wireFormat, Object o, DataOutputStream dataOut, BooleanStream bs) throws IOException {
        super.marshal2(wireFormat, o, dataOut, bs);
        SessionId info = (SessionId)o;
        this.writeString(info.getConnectionId(), dataOut, bs);
        if (bs.readBoolean()) {
            dataOut.writeLong(info.getSessionId());
        }
    }
}

