/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.jdbc;

import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadFactory;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import javax.sql.DataSource;
import org.activeio.FactoryFinder;
import org.activeio.command.WireFormat;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ActiveMQQueue;
import org.activemq.command.ActiveMQTopic;
import org.activemq.openwire.OpenWireFormat;
import org.activemq.store.MessageStore;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.TransactionStore;
import org.activemq.store.jdbc.JDBCAdapter;
import org.activemq.store.jdbc.JDBCMessageStore;
import org.activemq.store.jdbc.JDBCTopicMessageStore;
import org.activemq.store.jdbc.TransactionContext;
import org.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.activemq.store.memory.MemoryTransactionStore;
import org.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JDBCPersistenceAdapter
implements PersistenceAdapter {
    private static final Log log = LogFactory.getLog((Class)JDBCPersistenceAdapter.class);
    private static FactoryFinder factoryFinder = new FactoryFinder("META-INF/services/org/activemq/store/jdbc/");
    private WireFormat wireFormat = new OpenWireFormat(false);
    private DataSource dataSource;
    private JDBCAdapter adapter;
    private String adapterClass;
    private MemoryTransactionStore transactionStore;
    private ScheduledThreadPoolExecutor clockDaemon;
    private ScheduledFuture clockTicket;
    int cleanupPeriod = 300000;

    public JDBCPersistenceAdapter() {
    }

    public JDBCPersistenceAdapter(DataSource ds, WireFormat wireFormat) {
        this.dataSource = ds;
        this.wireFormat = wireFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getDestinations() {
        TransactionContext c = this.getTransactionContext();
        try {
            Set set = this.getAdapter().doGetDestinations(c);
            return set;
        }
        catch (IOException e) {
            Set set = Collections.EMPTY_SET;
            return set;
        }
        catch (SQLException e) {
            Set set = Collections.EMPTY_SET;
            return set;
        }
        finally {
            try {
                c.close();
            }
            catch (Throwable e) {}
        }
    }

    public MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        MessageStore rc = new JDBCMessageStore(this, this.getAdapter(), this.wireFormat, destination);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy(rc);
        }
        return rc;
    }

    public TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        TopicMessageStore rc = new JDBCTopicMessageStore(this, this.getAdapter(), this.wireFormat, destination);
        if (this.transactionStore != null) {
            rc = this.transactionStore.proxy(rc);
        }
        return rc;
    }

    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            this.transactionStore = new MemoryTransactionStore();
        }
        return this.transactionStore;
    }

    public long getLastMessageBrokerSequenceId() throws IOException {
        TransactionContext c = this.getTransactionContext();
        try {
            long l = this.getAdapter().doGetLastMessageBrokerSequenceId(c);
            return l;
        }
        catch (SQLException e) {
            throw IOExceptionSupport.create("Failed to get last broker message id: " + e, e);
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        TransactionContext transactionContext = this.getTransactionContext();
        transactionContext.begin();
        try {
            try {
                this.getAdapter().doCreateTables(transactionContext);
            }
            catch (SQLException e) {
                log.warn((Object)("Cannot create tables due to: " + e), (Throwable)e);
            }
        }
        finally {
            transactionContext.commit();
        }
        this.cleanup();
        if (this.cleanupPeriod > 0) {
            this.clockTicket = this.getScheduledThreadPoolExecutor().scheduleAtFixedRate(new Runnable(){

                public void run() {
                    JDBCPersistenceAdapter.this.cleanup();
                }
            }, (long)this.cleanupPeriod, (long)this.cleanupPeriod, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() throws Exception {
        if (this.clockTicket != null) {
            this.clockTicket.cancel(true);
            this.clockTicket = null;
            this.clockDaemon.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        TransactionContext c = this.getTransactionContext();
        try {
            log.debug((Object)"Cleaning up old messages.");
            c = this.getTransactionContext();
            this.getAdapter().doDeleteOldMessages(c);
        }
        catch (IOException e) {
            log.warn((Object)("Old message cleanup failed due to: " + e), (Throwable)e);
        }
        catch (SQLException e) {
            log.warn((Object)("Old message cleanup failed due to: " + e), (Throwable)e);
        }
        finally {
            try {
                c.close();
            }
            catch (Throwable e) {}
            log.debug((Object)"Cleanup done.");
        }
    }

    public void setScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor clockDaemon) {
        this.clockDaemon = clockDaemon;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        if (this.clockDaemon == null) {
            this.clockDaemon = new ScheduledThreadPoolExecutor(5, new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "Cleanup Timmer");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return this.clockDaemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JDBCAdapter getAdapter() throws IOException {
        if (this.adapter == null) {
            TransactionContext c = this.getTransactionContext();
            try {
                if (this.adapterClass == null) {
                    try {
                        String dirverName = c.getConnection().getMetaData().getDriverName();
                        dirverName = dirverName.replaceAll("[^a-zA-Z0-9\\-]", "_").toLowerCase();
                        try {
                            this.adapter = (DefaultJDBCAdapter)factoryFinder.newInstance(dirverName);
                            log.info((Object)("Database driver recognized: [" + dirverName + "]"));
                        }
                        catch (Throwable e) {
                            log.warn((Object)("Database driver NOT recognized: [" + dirverName + "].  Will use default JDBC implementation."));
                        }
                    }
                    catch (SQLException e) {
                        log.warn((Object)("JDBC error occured while trying to detect database type.  Will use default JDBC implementation: " + e.getMessage()));
                        log.debug((Object)("Reason: " + e), (Throwable)e);
                    }
                } else {
                    try {
                        Class<?> clazz = JDBCPersistenceAdapter.class.getClassLoader().loadClass(this.adapterClass);
                        this.adapter = (DefaultJDBCAdapter)clazz.newInstance();
                    }
                    catch (Throwable e) {
                        log.warn((Object)("Invalid JDBC adapter class class (" + this.adapterClass + ").  Will use default JDBC implementation."));
                        log.debug((Object)("Reason: " + e), e);
                    }
                }
                if (this.adapter == null) {
                    this.adapter = new DefaultJDBCAdapter();
                }
            }
            finally {
                c.close();
            }
        }
        return this.adapter;
    }

    public void setAdapter(JDBCAdapter adapter) {
        this.adapter = adapter;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public TransactionContext getTransactionContext(ConnectionContext context) {
        if (context == null) {
            return this.getTransactionContext();
        }
        TransactionContext answer = (TransactionContext)context.getLongTermStoreContext();
        if (answer == null) {
            answer = new TransactionContext(this.dataSource);
            context.setLongTermStoreContext(answer);
        }
        return answer;
    }

    public TransactionContext getTransactionContext() {
        return new TransactionContext(this.dataSource);
    }

    public void beginTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.begin();
    }

    public void commitTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.commit();
    }

    public void rollbackTransaction(ConnectionContext context) throws IOException {
        TransactionContext transactionContext = this.getTransactionContext(context);
        transactionContext.rollback();
    }

    public String getAdapterClass() {
        return this.adapterClass;
    }

    public void setAdapterClass(String adapterClass) {
        this.adapterClass = adapterClass;
    }

    public int getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    public void setCleanupPeriod(int cleanupPeriod) {
        this.cleanupPeriod = cleanupPeriod;
    }

    public void deleteAllMessages() throws IOException {
        TransactionContext c = this.getTransactionContext();
        try {
            this.getAdapter().doDropTables(c);
            this.getAdapter().doCreateTables(c);
        }
        catch (SQLException e) {
            throw IOExceptionSupport.create(e);
        }
        finally {
            c.close();
        }
    }
}

