/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.store.journal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.activeio.journal.RecordLocation;
import org.activemq.broker.ConnectionContext;
import org.activemq.command.ActiveMQTopic;
import org.activemq.command.JournalTopicAck;
import org.activemq.command.MessageId;
import org.activemq.command.SubscriptionInfo;
import org.activemq.store.MessageRecoveryListener;
import org.activemq.store.TopicMessageStore;
import org.activemq.store.journal.JournalMessageStore;
import org.activemq.store.journal.JournalPersistenceAdapter;
import org.activemq.transaction.Synchronization;
import org.activemq.util.Callback;
import org.activemq.util.SubscriptionKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JournalTopicMessageStore
extends JournalMessageStore
implements TopicMessageStore {
    private static final Log log = LogFactory.getLog((Class)JournalTopicMessageStore.class);
    private TopicMessageStore longTermStore;
    private HashMap ackedLastAckLocations = new HashMap();

    public JournalTopicMessageStore(JournalPersistenceAdapter adapter, TopicMessageStore checkpointStore, ActiveMQTopic destinationName) {
        super(adapter, checkpointStore, destinationName);
        this.longTermStore = checkpointStore;
    }

    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Throwable {
        this.peristenceAdapter.checkpoint(true);
        this.longTermStore.recoverSubscription(clientId, subscriptionName, listener);
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return this.longTermStore.lookupSubscription(clientId, subscriptionName);
    }

    public void addSubsciption(String clientId, String subscriptionName, String selector, boolean retroactive) throws IOException {
        this.peristenceAdapter.checkpoint(true);
        this.longTermStore.addSubsciption(clientId, subscriptionName, selector, retroactive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, final MessageId messageId) throws IOException {
        final boolean debug = log.isDebugEnabled();
        JournalTopicAck ack = new JournalTopicAck();
        ack.setDestination(this.destination);
        ack.setMessageId(messageId);
        ack.setMessageSequenceId(messageId.getBrokerSequenceId());
        ack.setSubscritionName(subscriptionName);
        ack.setClientId(clientId);
        ack.setTransactionId(context.getTransaction() != null ? context.getTransaction().getTransactionId() : null);
        final RecordLocation location = this.peristenceAdapter.writeCommand(ack, false);
        final SubscriptionKey key = new SubscriptionKey(clientId, subscriptionName);
        if (!context.isInTransaction()) {
            if (debug) {
                log.debug((Object)("Journalled acknowledge for: " + messageId + ", at: " + location));
            }
            this.acknowledge(messageId, location, key);
        } else {
            if (debug) {
                log.debug((Object)("Journalled transacted acknowledge for: " + messageId + ", at: " + location));
            }
            JournalTopicMessageStore journalTopicMessageStore = this;
            synchronized (journalTopicMessageStore) {
                this.inFlightTxLocations.add(location);
            }
            this.transactionStore.acknowledge(this, ack, location);
            context.getTransaction().addSynchronization(new Synchronization(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterCommit() {
                    if (debug) {
                        log.debug((Object)("Transacted acknowledge commit for: " + messageId + ", at: " + location));
                    }
                    JournalTopicMessageStore journalTopicMessageStore = JournalTopicMessageStore.this;
                    synchronized (journalTopicMessageStore) {
                        JournalTopicMessageStore.this.inFlightTxLocations.remove(location);
                        JournalTopicMessageStore.this.acknowledge(messageId, location, key);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterRollback() {
                    if (debug) {
                        log.debug((Object)("Transacted acknowledge rollback for: " + messageId + ", at: " + location));
                    }
                    JournalTopicMessageStore journalTopicMessageStore = JournalTopicMessageStore.this;
                    synchronized (journalTopicMessageStore) {
                        JournalTopicMessageStore.this.inFlightTxLocations.remove(location);
                    }
                }
            });
        }
    }

    public void replayAcknowledge(ConnectionContext context, String clientId, String subscritionName, MessageId messageId) {
        try {
            SubscriptionInfo sub = this.longTermStore.lookupSubscription(clientId, subscritionName);
            if (sub != null) {
                this.longTermStore.acknowledge(context, clientId, subscritionName, messageId);
            }
        }
        catch (Throwable e) {
            log.debug((Object)("Could not replay acknowledge for message '" + messageId + "'.  Message may have already been acknowledged. reason: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acknowledge(MessageId messageId, RecordLocation location, SubscriptionKey key) {
        JournalTopicMessageStore journalTopicMessageStore = this;
        synchronized (journalTopicMessageStore) {
            this.lastLocation = location;
            this.ackedLastAckLocations.put(key, messageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordLocation checkpoint() throws IOException {
        HashMap cpAckedLastAckLocations;
        JournalTopicMessageStore journalTopicMessageStore = this;
        synchronized (journalTopicMessageStore) {
            cpAckedLastAckLocations = this.ackedLastAckLocations;
            this.ackedLastAckLocations = new HashMap();
        }
        return super.checkpoint(new Callback(){

            public void execute() throws Throwable {
                Iterator iterator = cpAckedLastAckLocations.keySet().iterator();
                while (iterator.hasNext()) {
                    SubscriptionKey subscriptionKey = (SubscriptionKey)iterator.next();
                    MessageId identity = (MessageId)cpAckedLastAckLocations.get(subscriptionKey);
                    JournalTopicMessageStore.this.longTermStore.acknowledge(JournalTopicMessageStore.this.transactionTemplate.getContext(), subscriptionKey.clientId, subscriptionKey.subscriptionName, identity);
                }
            }
        });
    }

    public TopicMessageStore getLongTermTopicMessageStore() {
        return this.longTermStore;
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        this.longTermStore.deleteSubscription(clientId, subscriptionName);
    }
}

