/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.tcp;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.activeio.command.WireFormat;
import org.activeio.command.WireFormatFactory;
import org.activemq.command.BrokerInfo;
import org.activemq.openwire.OpenWireFormatFactory;
import org.activemq.transport.TransportAcceptListener;
import org.activemq.transport.TransportServer;
import org.activemq.transport.tcp.TcpTransport;
import org.activemq.transport.tcp.TcpTransportFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TcpTransportServer
implements TransportServer,
Runnable {
    private static final Log log = LogFactory.getLog((Class)TcpTransportServer.class);
    private URI location;
    private Thread serverSocketThread;
    private ServerSocket serverSocket;
    private AtomicBoolean closed;
    private AtomicBoolean started;
    private int backlog = 5000;
    private TransportAcceptListener acceptListener;
    private WireFormatFactory wireFormatFactory = new OpenWireFormatFactory();

    public TcpTransportServer(URI location) throws IOException, URISyntaxException {
        this.location = location;
        this.closed = new AtomicBoolean(false);
        this.started = new AtomicBoolean(false);
        this.serverSocket = this.createServerSocket(location);
        this.serverSocket.setSoTimeout(2000);
        this.updatePhysicalUri(location);
    }

    public URI getLocation() {
        return this.location;
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public WireFormatFactory getWireFormatFactory() {
        return this.wireFormatFactory;
    }

    public void setWireFormatFactory(WireFormatFactory wireFormatFactory) {
        this.wireFormatFactory = wireFormatFactory;
    }

    public TransportAcceptListener getAcceptListener() {
        return this.acceptListener;
    }

    public void setAcceptListener(TransportAcceptListener acceptListener) {
        this.acceptListener = acceptListener;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
    }

    public URI getConnectURI() {
        return this.location;
    }

    public void start() throws Exception {
        if (this.started.compareAndSet(false, true)) {
            log.info((Object)("Listening for connections at: " + this.location));
            this.serverSocketThread = new Thread((Runnable)this, this.toString());
            this.serverSocketThread.setDaemon(true);
            this.serverSocketThread.setPriority(9);
            this.serverSocketThread.start();
        }
    }

    public void stop() throws Exception {
        if (this.closed.compareAndSet(false, true) && this.serverSocket != null) {
            this.serverSocket.close();
            if (this.serverSocketThread != null) {
                this.serverSocketThread.join();
                this.serverSocketThread = null;
            }
        }
    }

    public void run() {
        while (!this.closed.get()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
                if (socket == null) continue;
                if (this.closed.get() || this.acceptListener == null) {
                    socket.close();
                    continue;
                }
                HashMap options = new HashMap();
                WireFormat format = this.wireFormatFactory.createWireFormat();
                TcpTransport transport = new TcpTransport(format, socket);
                this.acceptListener.onAccept(TcpTransportFactory.configure(transport, format, options));
            }
            catch (SocketTimeoutException ste) {
            }
            catch (Exception e) {
                if (!this.closed.get()) {
                    log.warn((Object)"run()", (Throwable)e);
                }
                if (this.acceptListener == null) continue;
                this.acceptListener.onAcceptError(e);
            }
        }
    }

    public String toString() {
        return "TcpTransportServer@" + this.location;
    }

    protected void updatePhysicalUri(URI bindAddr) throws URISyntaxException, UnknownHostException {
        this.location = new URI(bindAddr.getScheme(), bindAddr.getUserInfo(), this.resolveHostName(bindAddr.getHost()), this.serverSocket.getLocalPort(), bindAddr.getPath(), bindAddr.getQuery(), bindAddr.getFragment());
    }

    protected String resolveHostName(String hostName) throws UnknownHostException {
        String result = hostName;
        if (hostName != null && (hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1"))) {
            result = InetAddress.getLocalHost().getHostName();
        }
        return result;
    }

    protected ServerSocket createServerSocket(URI bind) throws UnknownHostException, IOException {
        ServerSocket answer = null;
        String host = bind.getHost();
        host = host == null || host.length() == 0 ? "localhost" : host;
        InetAddress addr = InetAddress.getByName(host);
        answer = host.trim().equals("localhost") || addr.equals(InetAddress.getLocalHost()) ? new ServerSocket(bind.getPort(), this.backlog) : new ServerSocket(bind.getPort(), this.backlog, addr);
        return answer;
    }
}

