/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.transport.vm;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.transport.FutureResponse;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;

public class VMTransport
implements Transport {
    protected VMTransport peer;
    protected TransportListener transportListener;
    protected boolean disposed;
    protected boolean marshal;
    protected boolean network;
    protected List queue = Collections.synchronizedList(new LinkedList());

    public synchronized VMTransport getPeer() {
        return this.peer;
    }

    public synchronized void setPeer(VMTransport peer) {
        this.peer = peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Command command) throws IOException {
        List queue;
        TransportListener tl;
        if (this.disposed) {
            throw new IOException("Transport disposed.");
        }
        if (this.peer == null) {
            throw new IOException("Peer not connected.");
        }
        VMTransport vMTransport = this.peer;
        synchronized (vMTransport) {
            if (this.peer.disposed) {
                throw new IOException("Peer disposed.");
            }
            tl = this.peer.transportListener;
            queue = this.peer.queue;
        }
        if (tl != null) {
            tl.onCommand(command);
        } else {
            queue.add(command);
        }
    }

    public FutureResponse asyncRequest(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public Response request(Command command) throws IOException {
        throw new AssertionError((Object)"Unsupported Method");
    }

    public synchronized void setTransportListener(TransportListener commandListener) {
        this.transportListener = commandListener;
    }

    public void start() throws Exception {
        if (this.transportListener == null) {
            throw new IOException("TransportListener not set.");
        }
        Iterator iter = this.queue.iterator();
        while (iter.hasNext()) {
            Command command = (Command)iter.next();
            this.transportListener.onCommand(command);
            iter.remove();
        }
    }

    public void stop() throws Exception {
        TransportListener cl;
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.peer != null && !this.peer.disposed && (cl = this.peer.transportListener) != null) {
            cl.onException(new IOException("Peer disposed."));
        }
    }

    public Object narrow(Class target) {
        if (target.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public boolean isMarshal() {
        return this.marshal;
    }

    public void setMarshal(boolean marshal) {
        this.marshal = marshal;
    }

    public boolean isNetwork() {
        return this.network;
    }

    public void setNetwork(boolean network) {
        this.network = network;
    }
}

