/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.xbean;

import java.beans.PropertyEditorManager;
import java.net.URI;
import org.activemq.broker.BrokerService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.xbean.spring.context.ResourceXmlApplicationContext;
import org.xbean.spring.context.impl.URIEditor;

public class BrokerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)BrokerFactoryBean.class);
    private Resource config;
    private BrokerService broker;

    public BrokerFactoryBean() {
    }

    public BrokerFactoryBean(Resource config) {
        this.config = config;
    }

    public Object getObject() throws Exception {
        return this.broker;
    }

    public Class getObjectType() {
        return BrokerService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.config == null) {
            throw new IllegalArgumentException("config property must be set");
        }
        ResourceXmlApplicationContext context = new ResourceXmlApplicationContext(this.config);
        try {
            this.broker = (BrokerService)context.getBean("broker");
        }
        catch (BeansException e) {
            log.trace((Object)("No bean named broker available: " + (Object)((Object)e)), (Throwable)e);
        }
        if (this.broker == null) {
            String[] names = context.getBeanNamesForType(BrokerService.class);
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                this.broker = (BrokerService)context.getBean(name);
                if (this.broker != null) break;
            }
        }
        if (this.broker == null) {
            throw new IllegalArgumentException("The configuration has no BrokerService instance for resource: " + this.config);
        }
        this.broker.start();
    }

    public void destroy() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public Resource getConfig() {
        return this.config;
    }

    public void setConfig(Resource config) {
        this.config = config;
    }

    public BrokerService getBroker() {
        return this.broker;
    }

    static {
        PropertyEditorManager.registerEditor(URI.class, URIEditor.class);
    }
}

