/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import java.io.IOException;
import java.net.URI;
import org.activeio.FactoryFinder;
import org.activemq.broker.BrokerService;
import org.activemq.util.IOExceptionSupport;

public class BrokerFactory {
    private static final FactoryFinder brokerFactoryHandlerFinder = new FactoryFinder("META-INF/services/org/activemq/broker/");

    public static BrokerFactoryHandler createBrokerFactoryHandler(String type) throws IOException {
        try {
            return (BrokerFactoryHandler)brokerFactoryHandlerFinder.newInstance(type);
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create("Could load " + type + " factory:" + e, e);
        }
    }

    public static BrokerService createBroker(URI brokerURI) throws Exception {
        if (brokerURI.getScheme() == null) {
            throw new IllegalArgumentException("Invalid broker URI, no scheme specified: " + brokerURI);
        }
        BrokerFactoryHandler handler = BrokerFactory.createBrokerFactoryHandler(brokerURI.getScheme());
        BrokerService broker = handler.createBroker(brokerURI);
        return broker;
    }

    public static interface BrokerFactoryHandler {
        public BrokerService createBroker(URI var1) throws Exception;
    }
}

