/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import java.io.IOException;
import org.activemq.broker.AbstractConnection;
import org.activemq.broker.Broker;
import org.activemq.broker.TransportConnector;
import org.activemq.command.Command;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.Message;
import org.activemq.command.MessageDispatch;
import org.activemq.command.Response;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportListener;

public class TransportConnection
extends AbstractConnection {
    private final Transport transport;
    private boolean slow;
    private boolean markedCandidate;
    private boolean blockedCandidate;
    private boolean blocked;
    private boolean connected;
    private boolean active;
    private long timeStamp = 0L;

    public TransportConnection(TransportConnector connector, Transport transport, Broker broker, TaskRunnerFactory taskRunnerFactory) {
        super(connector, broker, taskRunnerFactory);
        connector.setBrokerName(broker.getBrokerName());
        this.transport = transport;
        this.transport.setTransportListener(new TransportListener(){

            public void onCommand(Command command) {
                Response response = TransportConnection.this.service(command);
                if (response != null) {
                    TransportConnection.this.dispatch(response);
                }
            }

            public void onException(IOException exception) {
                TransportConnection.this.serviceTransportException(exception);
            }
        });
        this.connected = true;
    }

    public void start() throws Exception {
        this.transport.start();
        this.active = true;
        super.start();
    }

    public void stop() throws Exception {
        this.transport.stop();
        this.active = false;
        super.stop();
    }

    public boolean isBlockedCandidate() {
        return this.blockedCandidate;
    }

    public void setBlockedCandidate(boolean blockedCandidate) {
        this.blockedCandidate = blockedCandidate;
    }

    public boolean isMarkedCandidate() {
        return this.markedCandidate;
    }

    public void setMarkedCandidate(boolean markedCandidate) {
        this.markedCandidate = markedCandidate;
        if (!markedCandidate) {
            this.timeStamp = 0L;
            this.blockedCandidate = false;
        }
    }

    public void setSlow(boolean slow) {
        this.slow = slow;
    }

    public boolean isSlow() {
        return this.slow;
    }

    public boolean isMarkedBlockedCandidate() {
        return this.markedCandidate;
    }

    public void doMark() {
        if (this.timeStamp == 0L) {
            this.timeStamp = System.currentTimeMillis();
        }
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(Command command) {
        if (this.isValidForNetwork(command)) {
            try {
                this.setMarkedCandidate(true);
                this.transport.oneway(command);
            }
            catch (IOException e) {
                this.serviceException(e);
            }
            finally {
                this.setMarkedCandidate(false);
            }
        }
    }

    protected boolean isValidForNetwork(Command command) {
        ConsumerInfo info;
        MessageDispatch md;
        Message message;
        boolean result = true;
        if (this.demandForwardingBridge && command.isMessageDispatch() && (message = (md = (MessageDispatch)command).getMessage()).isAdvisory() && message.getDataStructure() != null && message.getDataStructure().getDataStructureType() == 5 && (info = (ConsumerInfo)message.getDataStructure()).isNetworkSubscription()) {
            result = false;
        }
        return result;
    }
}

