/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.activemq.broker.Broker;
import org.activemq.broker.BrokerFilter;
import org.activemq.broker.Connection;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.Connector;
import org.activemq.broker.TransportConnection;
import org.activemq.broker.TransportStatusDetector;
import org.activemq.broker.jmx.ManagedTransportConnector;
import org.activemq.command.BrokerInfo;
import org.activemq.command.ConnectionInfo;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.transport.Transport;
import org.activemq.transport.TransportAcceptListener;
import org.activemq.transport.TransportFactory;
import org.activemq.transport.TransportServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportConnector
implements Connector {
    private static final Log log = LogFactory.getLog((Class)TransportConnector.class);
    private Broker broker;
    private BrokerFilter brokerFilter;
    private TransportServer server;
    private URI uri;
    private BrokerInfo brokerInfo = new BrokerInfo();
    private TaskRunnerFactory taskRunnerFactory = null;
    protected CopyOnWriteArrayList connections = new CopyOnWriteArrayList();
    protected TransportStatusDetector statusDector = new TransportStatusDetector(this);

    public CopyOnWriteArrayList getConnections() {
        return this.connections;
    }

    public TransportConnector() {
    }

    public TransportConnector(Broker broker, TransportServer server) {
        this();
        this.setBroker(broker);
        this.setServer(server);
    }

    public ManagedTransportConnector asManagedConnector(MBeanServer mbeanServer, ObjectName connectorName) throws IOException, URISyntaxException {
        return new ManagedTransportConnector(mbeanServer, connectorName, this.getBroker(), this.getServer());
    }

    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
        this.brokerInfo = brokerInfo;
    }

    public TransportServer getServer() throws IOException, URISyntaxException {
        if (this.server == null) {
            this.setServer(this.createTransportServer());
        }
        return this.server;
    }

    public String getName() throws IOException, URISyntaxException {
        return this.getServer().getConnectURI().toString();
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
        this.brokerInfo.setBrokerId(broker.getBrokerId());
    }

    public void setBrokerName(String brokerName) {
        this.brokerInfo.setBrokerName(brokerName);
    }

    public void setServer(TransportServer server) {
        this.server = server;
        this.server.setAcceptListener(new TransportAcceptListener(){

            public void onAccept(Transport transport) {
                try {
                    Connection connection = TransportConnector.this.createConnection(transport);
                    connection.start();
                }
                catch (Exception e) {
                    this.onAcceptError(e);
                }
            }

            public void onAcceptError(Exception error) {
                log.error((Object)("Could not accept connection: " + error), (Throwable)error);
            }
        });
        this.server.setBrokerInfo(this.brokerInfo);
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public void start() throws Exception {
        this.getServer().start();
        log.info((Object)("Accepting connection on: " + this.getServer().getConnectURI()));
        this.statusDector.start();
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        this.statusDector.stop();
        Iterator iter = this.connections.iterator();
        while (iter.hasNext()) {
            ConnectionContext context = (ConnectionContext)iter.next();
            context.getConnection().stop();
        }
    }

    protected Connection createConnection(Transport transport) throws IOException {
        return new TransportConnection(this, transport, this.getBrokerFilter(), this.taskRunnerFactory);
    }

    protected BrokerFilter getBrokerFilter() {
        if (this.brokerFilter == null) {
            if (this.broker == null) {
                throw new IllegalArgumentException("You must specify the broker property. Maybe this connector should be added to a broker?");
            }
            this.brokerFilter = new BrokerFilter(this.broker){

                public void addConnection(ConnectionContext context, ConnectionInfo info) throws Throwable {
                    TransportConnector.this.connections.add((Object)context);
                    super.addConnection(context, info);
                }

                public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Throwable {
                    TransportConnector.this.connections.remove((Object)context);
                    super.removeConnection(context, info, error);
                }
            };
        }
        return this.brokerFilter;
    }

    protected TransportServer createTransportServer() throws IOException, URISyntaxException {
        if (this.uri == null) {
            throw new IllegalArgumentException("You must specify either a server or uri property");
        }
        if (this.broker == null) {
            throw new IllegalArgumentException("You must specify the broker property. Maybe this connector should be added to a broker?");
        }
        return TransportFactory.bind(this.broker.getBrokerId().getBrokerId(), this.uri);
    }
}

