/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.jmx;

import java.io.IOException;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.activemq.broker.jmx.DestinationView;
import org.activemq.broker.jmx.ManagedQueueRegion;
import org.activemq.broker.jmx.ManagedTempQueueRegion;
import org.activemq.broker.jmx.ManagedTempTopicRegion;
import org.activemq.broker.jmx.ManagedTopicRegion;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.Region;
import org.activemq.broker.region.RegionBroker;
import org.activemq.broker.region.policy.PolicyMap;
import org.activemq.command.ActiveMQDestination;
import org.activemq.memory.UsageManager;
import org.activemq.store.PersistenceAdapter;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.util.JMXSupport;

public class ManagedRegionBroker
extends RegionBroker {
    private final MBeanServer mbeanServer;
    private final ObjectName brokerObjectName;

    public ManagedRegionBroker(MBeanServer mbeanServer, ObjectName brokerObjectName, TaskRunnerFactory taskRunnerFactory, UsageManager memoryManager, PersistenceAdapter adapter, PolicyMap policyMap) throws IOException {
        super(taskRunnerFactory, memoryManager, adapter, policyMap);
        this.mbeanServer = mbeanServer;
        this.brokerObjectName = brokerObjectName;
    }

    protected Region createQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter adapter, PolicyMap policyMap) {
        return new ManagedQueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, adapter, policyMap);
    }

    protected Region createTempQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        return new ManagedTempQueueRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory);
    }

    protected Region createTempTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        return new ManagedTempTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory);
    }

    protected Region createTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter adapter, PolicyMap policyMap) {
        return new ManagedTopicRegion(this, this.destinationStatistics, memoryManager, taskRunnerFactory, adapter, policyMap);
    }

    public void register(ActiveMQDestination destName, Destination destination) throws Throwable {
        Hashtable<String, String> map = new Hashtable<String, String>(this.brokerObjectName.getKeyPropertyList());
        map.put("Type", destName.getDestinationTypeAsString());
        map.put("Destination", JMXSupport.encodeObjectNamePart(destName.getPhysicalName()));
        ObjectName destObjectName = new ObjectName(this.brokerObjectName.getDomain(), map);
        DestinationView view = new DestinationView(destination);
        this.mbeanServer.registerMBean(view, destObjectName);
    }

    public void unregister(ActiveMQDestination destName) throws Throwable {
        Hashtable<String, String> map = new Hashtable<String, String>(this.brokerObjectName.getKeyPropertyList());
        map.put("Type", destName.getDestinationTypeAsString());
        map.put("Destination", JMXSupport.encodeObjectNamePart(destName.getPhysicalName()));
        ObjectName destObjectName = new ObjectName(this.brokerObjectName.getDomain(), map);
        this.mbeanServer.unregisterMBean(destObjectName);
    }
}

