/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import javax.jms.JMSException;
import org.activemq.broker.Broker;
import org.activemq.broker.Connection;
import org.activemq.broker.ConnectionContext;
import org.activemq.broker.region.Destination;
import org.activemq.broker.region.DestinationStatistics;
import org.activemq.broker.region.QueueRegion;
import org.activemq.broker.region.Region;
import org.activemq.broker.region.TempQueueRegion;
import org.activemq.broker.region.TempTopicRegion;
import org.activemq.broker.region.TopicRegion;
import org.activemq.broker.region.policy.PolicyMap;
import org.activemq.command.ActiveMQDestination;
import org.activemq.command.BrokerId;
import org.activemq.command.ConnectionInfo;
import org.activemq.command.ConsumerInfo;
import org.activemq.command.Message;
import org.activemq.command.MessageAck;
import org.activemq.command.ProducerInfo;
import org.activemq.command.RemoveSubscriptionInfo;
import org.activemq.command.SessionInfo;
import org.activemq.command.TransactionId;
import org.activemq.memory.UsageManager;
import org.activemq.store.PersistenceAdapter;
import org.activemq.store.memory.MemoryPersistenceAdapter;
import org.activemq.thread.TaskRunnerFactory;
import org.activemq.util.IdGenerator;
import org.activemq.util.LongSequenceGenerator;

public class RegionBroker
implements Broker {
    private static final IdGenerator brokerIdGenerator = new IdGenerator();
    private final Region queueRegion;
    private final Region topicRegion;
    private final Region tempQueueRegion;
    private final Region tempTopicRegion;
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    private final CopyOnWriteArrayList connections = new CopyOnWriteArrayList();
    private final CopyOnWriteArraySet destinations = new CopyOnWriteArraySet();
    private final LongSequenceGenerator sequenceGenerator = new LongSequenceGenerator();
    private BrokerId brokerId;
    private String brokerName;

    public RegionBroker(TaskRunnerFactory taskRunnerFactory, UsageManager memoryManager, PersistenceAdapter adapter) throws IOException {
        this(taskRunnerFactory, memoryManager, RegionBroker.createDefaultPersistenceAdapter(memoryManager), null);
    }

    public RegionBroker(TaskRunnerFactory taskRunnerFactory, UsageManager memoryManager, PersistenceAdapter adapter, PolicyMap policyMap) throws IOException {
        this.sequenceGenerator.setLastSequenceId(adapter.getLastMessageBrokerSequenceId());
        this.queueRegion = this.createQueueRegion(memoryManager, taskRunnerFactory, adapter, policyMap);
        this.topicRegion = this.createTopicRegion(memoryManager, taskRunnerFactory, adapter, policyMap);
        this.tempQueueRegion = this.createTempQueueRegion(memoryManager, taskRunnerFactory);
        this.tempTopicRegion = this.createTempTopicRegion(memoryManager, taskRunnerFactory);
    }

    protected Region createTempTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        return new TempTopicRegion(this.destinationStatistics, memoryManager, taskRunnerFactory);
    }

    protected Region createTempQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory) {
        return new TempQueueRegion(this.destinationStatistics, memoryManager, taskRunnerFactory);
    }

    protected Region createTopicRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter adapter, PolicyMap policyMap) {
        return new TopicRegion(this.destinationStatistics, memoryManager, taskRunnerFactory, adapter, policyMap);
    }

    protected Region createQueueRegion(UsageManager memoryManager, TaskRunnerFactory taskRunnerFactory, PersistenceAdapter adapter, PolicyMap policyMap) {
        return new QueueRegion(this.destinationStatistics, memoryManager, taskRunnerFactory, adapter, policyMap);
    }

    private static PersistenceAdapter createDefaultPersistenceAdapter(UsageManager memoryManager) throws IOException {
        return new MemoryPersistenceAdapter();
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public void addConnection(ConnectionContext context, ConnectionInfo info) throws Throwable {
        this.connections.add((Object)context.getConnection());
    }

    public void removeConnection(ConnectionContext context, ConnectionInfo info, Throwable error) throws Throwable {
        this.connections.remove((Object)context.getConnection());
    }

    public Connection[] getClients() throws Throwable {
        ArrayList l = new ArrayList(this.connections);
        Connection[] rc = new Connection[l.size()];
        l.toArray(rc);
        return rc;
    }

    public Destination addDestination(ConnectionContext context, ActiveMQDestination destination) throws Throwable {
        if (this.destinations.contains((Object)destination)) {
            throw new JMSException("Destination already exists: " + destination);
        }
        Destination answer = null;
        switch (destination.getDestinationType()) {
            case 1: {
                answer = this.queueRegion.addDestination(context, destination);
                break;
            }
            case 2: {
                answer = this.topicRegion.addDestination(context, destination);
                break;
            }
            case 5: {
                answer = this.tempQueueRegion.addDestination(context, destination);
                break;
            }
            case 6: {
                answer = this.tempTopicRegion.addDestination(context, destination);
                break;
            }
            default: {
                this.throwUnknownDestinationType(destination);
            }
        }
        this.destinations.add((Object)destination);
        return answer;
    }

    public void removeDestination(ConnectionContext context, ActiveMQDestination destination, long timeout) throws Throwable {
        if (!this.destinations.contains((Object)destination)) {
            throw new JMSException("Destination does not exist: " + destination);
        }
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.removeDestination(context, destination, timeout);
                break;
            }
            case 2: {
                this.topicRegion.removeDestination(context, destination, timeout);
                break;
            }
            case 5: {
                this.tempQueueRegion.removeDestination(context, destination, timeout);
                break;
            }
            case 6: {
                this.tempTopicRegion.removeDestination(context, destination, timeout);
                break;
            }
            default: {
                this.throwUnknownDestinationType(destination);
            }
        }
        this.destinations.remove((Object)destination);
    }

    public ActiveMQDestination[] getDestinations() throws Throwable {
        ArrayList l = new ArrayList(this.destinations);
        ActiveMQDestination[] rc = new ActiveMQDestination[l.size()];
        l.toArray(rc);
        return rc;
    }

    public void addSession(ConnectionContext context, SessionInfo info) throws Throwable {
    }

    public void removeSession(ConnectionContext context, SessionInfo info) throws Throwable {
    }

    public void addProducer(ConnectionContext context, ProducerInfo info) throws Throwable {
    }

    public void removeProducer(ConnectionContext context, ProducerInfo info) throws Throwable {
    }

    public void addConsumer(ConnectionContext context, ConsumerInfo info) throws Throwable {
        ActiveMQDestination destination = info.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.addConsumer(context, info);
                break;
            }
            case 2: {
                this.topicRegion.addConsumer(context, info);
                break;
            }
            case 5: {
                this.tempQueueRegion.addConsumer(context, info);
                break;
            }
            case 6: {
                this.tempTopicRegion.addConsumer(context, info);
                break;
            }
            default: {
                this.throwUnknownDestinationType(destination);
            }
        }
    }

    public void removeConsumer(ConnectionContext context, ConsumerInfo info) throws Throwable {
        ActiveMQDestination destination = info.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.removeConsumer(context, info);
                break;
            }
            case 2: {
                this.topicRegion.removeConsumer(context, info);
                break;
            }
            case 5: {
                this.tempQueueRegion.removeConsumer(context, info);
                break;
            }
            case 6: {
                this.tempTopicRegion.removeConsumer(context, info);
                break;
            }
            default: {
                this.throwUnknownDestinationType(destination);
            }
        }
    }

    public void removeSubscription(ConnectionContext context, RemoveSubscriptionInfo info) throws Throwable {
        this.topicRegion.removeSubscription(context, info);
    }

    public void send(ConnectionContext context, Message message) throws Throwable {
        message.getMessageId().setBrokerSequenceId(this.sequenceGenerator.getNextSequenceId());
        ActiveMQDestination destination = message.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.send(context, message);
                break;
            }
            case 2: {
                this.topicRegion.send(context, message);
                break;
            }
            case 5: {
                this.tempQueueRegion.send(context, message);
                break;
            }
            case 6: {
                this.tempTopicRegion.send(context, message);
                break;
            }
            default: {
                this.throwUnknownDestinationType(destination);
            }
        }
    }

    public void acknowledge(ConnectionContext context, MessageAck ack) throws Throwable {
        ActiveMQDestination destination = ack.getDestination();
        switch (destination.getDestinationType()) {
            case 1: {
                this.queueRegion.acknowledge(context, ack);
                break;
            }
            case 2: {
                this.topicRegion.acknowledge(context, ack);
                break;
            }
            case 5: {
                this.tempQueueRegion.acknowledge(context, ack);
                break;
            }
            case 6: {
                this.tempTopicRegion.acknowledge(context, ack);
                break;
            }
            default: {
                this.throwUnknownDestinationType(destination);
            }
        }
    }

    public TransactionId[] getPreparedTransactions(ConnectionContext context) throws Throwable {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void beginTransaction(ConnectionContext context, TransactionId xid) throws Throwable {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public int prepareTransaction(ConnectionContext context, TransactionId xid) throws Throwable {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void rollbackTransaction(ConnectionContext context, TransactionId xid) throws Throwable {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void commitTransaction(ConnectionContext context, TransactionId xid, boolean onePhase) throws Throwable {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void forgetTransaction(ConnectionContext context, TransactionId transactionId) throws Throwable {
        throw new IllegalAccessException("Transaction operation not implemented by this broker.");
    }

    public void gc() {
        this.queueRegion.gc();
        this.topicRegion.gc();
    }

    public BrokerId getBrokerId() {
        if (this.brokerId == null) {
            this.brokerId = new BrokerId(brokerIdGenerator.generateId());
        }
        return this.brokerId;
    }

    public void setBrokerId(BrokerId brokerId) {
        this.brokerId = brokerId;
    }

    public String getBrokerName() {
        if (this.brokerName == null) {
            try {
                this.brokerName = InetAddress.getLocalHost().getHostName().toLowerCase();
            }
            catch (Exception e) {
                this.brokerName = "localhost";
            }
        }
        return this.brokerName;
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    protected void throwUnknownDestinationType(ActiveMQDestination destination) throws JMSException {
        throw new JMSException("Unknown destination type: " + destination.getDestinationType());
    }
}

