/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import org.activemq.command.ActiveMQDestination;
import org.activemq.command.BaseCommand;
import org.activemq.command.BrokerId;
import org.activemq.command.ConsumerId;
import org.activemq.command.RemoveInfo;
import org.activemq.command.Response;
import org.activemq.command.SessionInfo;
import org.activemq.filter.BooleanExpression;
import org.activemq.state.CommandVisitor;

public class ConsumerInfo
extends BaseCommand {
    public static final byte DATA_STRUCTURE_TYPE = 5;
    public static final byte HIGH_PRIORITY = 10;
    public static final byte NORMAL_PRIORITY = 0;
    public static final byte NETWORK_CONSUMER_PRIORITY = -5;
    public static final byte LOW_PRIORITY = -10;
    protected ConsumerId consumerId;
    protected ActiveMQDestination destination;
    protected int prefetchSize;
    protected boolean browser;
    protected boolean dispatchAsync;
    protected String selector;
    protected String subcriptionName;
    protected boolean noLocal;
    protected boolean exclusive;
    protected boolean retroactive;
    protected byte priority;
    protected BrokerId[] brokerPath;
    protected transient BooleanExpression additionalPredicate;
    protected transient boolean networkSubscription;

    public ConsumerInfo() {
    }

    public ConsumerInfo(ConsumerId consumerId) {
        this.consumerId = consumerId;
    }

    public ConsumerInfo(SessionInfo sessionInfo, long consumerId) {
        this.consumerId = new ConsumerId(sessionInfo.getSessionId(), consumerId);
    }

    public ConsumerInfo copy() {
        ConsumerInfo info = new ConsumerInfo();
        this.copy(info);
        return info;
    }

    public void copy(ConsumerInfo info) {
        super.copy(info);
        info.consumerId = this.consumerId;
        info.destination = this.destination;
        info.prefetchSize = this.prefetchSize;
        info.browser = this.browser;
        info.dispatchAsync = this.dispatchAsync;
        info.selector = this.selector;
        info.subcriptionName = this.subcriptionName;
        info.noLocal = this.noLocal;
        info.exclusive = this.exclusive;
        info.retroactive = this.retroactive;
        info.priority = this.priority;
        info.brokerPath = this.brokerPath;
    }

    public boolean isDurable() {
        return this.subcriptionName != null;
    }

    public byte getDataStructureType() {
        return 5;
    }

    public ConsumerId getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(ConsumerId consumerId) {
        this.consumerId = consumerId;
    }

    public boolean isBrowser() {
        return this.browser;
    }

    public void setBrowser(boolean browser) {
        this.browser = browser;
    }

    public ActiveMQDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ActiveMQDestination destination) {
        this.destination = destination;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        this.dispatchAsync = dispatchAsync;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getSubcriptionName() {
        return this.subcriptionName;
    }

    public void setSubcriptionName(String durableSubscriptionId) {
        this.subcriptionName = durableSubscriptionId;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isRetroactive() {
        return this.retroactive;
    }

    public void setRetroactive(boolean retroactive) {
        this.retroactive = retroactive;
    }

    public RemoveInfo createRemoveCommand() {
        RemoveInfo command = new RemoveInfo(this.getConsumerId());
        command.setResponseRequired(this.isResponseRequired());
        return command;
    }

    public byte getPriority() {
        return this.priority;
    }

    public void setPriority(byte priority) {
        this.priority = priority;
    }

    public BrokerId[] getBrokerPath() {
        return this.brokerPath;
    }

    public void setBrokerPath(BrokerId[] brokerPath) {
        this.brokerPath = brokerPath;
    }

    public BooleanExpression getAdditionalPredicate() {
        return this.additionalPredicate;
    }

    public void setAdditionalPredicate(BooleanExpression additionalPredicate) {
        this.additionalPredicate = additionalPredicate;
    }

    public Response visit(CommandVisitor visitor) throws Throwable {
        return visitor.processAddConsumer(this);
    }

    public boolean isNetworkSubscription() {
        return this.networkSubscription;
    }

    public void setNetworkSubscription(boolean networkSubscription) {
        this.networkSubscription = networkSubscription;
    }
}

