/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.command;

import java.util.Arrays;
import org.activemq.command.Command;
import org.activemq.command.Response;
import org.activemq.state.CommandVisitor;

public class WireFormatInfo
implements Command {
    public static final byte DATA_STRUCTURE_TYPE = 1;
    private static final byte[] MAGIC = new byte[]{65, 99, 116, 105, 118, 101, 77, 81};
    public static final long STACK_TRACE_MASK = 1L;
    public static final long TCP_NO_DELAY_MASK = 2L;
    public static final long CACHE_MASK = 4L;
    public static final long COMPRESSION_MASK = 8L;
    protected int version;
    protected byte[] magic = MAGIC;
    protected int options;

    public byte getDataStructureType() {
        return 1;
    }

    public boolean isWireFormatInfo() {
        return true;
    }

    public byte[] getMagic() {
        return this.magic;
    }

    public void setMagic(byte[] magic) {
        this.magic = magic;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isValid() {
        return this.magic != null && Arrays.equals(this.magic, MAGIC);
    }

    public void setCommandId(short value) {
    }

    public short getCommandId() {
        return 0;
    }

    public boolean isResponseRequired() {
        return false;
    }

    public boolean isResponse() {
        return false;
    }

    public boolean isBrokerInfo() {
        return false;
    }

    public boolean isMessageDispatch() {
        return false;
    }

    public boolean isMessage() {
        return false;
    }

    public void setResponseRequired(boolean responseRequired) {
    }

    public String toString() {
        return "WireFormatInfo {version=" + this.version + "}";
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public boolean isStackTraceEnabled() {
        return ((long)this.options & 1L) != 0L;
    }

    public void setStackTraceEnabled(boolean enable) {
        this.options = enable ? (int)((long)this.options | 1L) : (int)((long)this.options & 0xFFFFFFFFFFFFFFFEL);
    }

    public boolean isTcpNoDelayEnabled() {
        return ((long)this.options & 2L) != 0L;
    }

    public void setTcpNoDelayEnabled(boolean enable) {
        this.options = enable ? (int)((long)this.options | 2L) : (int)((long)this.options & 0xFFFFFFFFFFFFFFFDL);
    }

    public boolean isCacheEnabled() {
        return ((long)this.options & 4L) != 0L;
    }

    public void setCacheEnabled(boolean enable) {
        this.options = enable ? (int)((long)this.options | 4L) : (int)((long)this.options & 0xFFFFFFFFFFFFFFFBL);
    }

    public Response visit(CommandVisitor visitor) throws Throwable {
        return visitor.processWireFormat(this);
    }

    public boolean isMarshallAware() {
        return false;
    }
}

