/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.filter;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.activemq.command.ActiveMQDestination;
import org.activemq.filter.DestinationMapEntry;
import org.activemq.filter.DestinationMapNode;

public class DestinationMap {
    private DestinationMapNode rootNode = new DestinationMapNode(null);
    protected static final String ANY_DESCENDENT = ">";
    protected static final String ANY_CHILD = "*";

    public synchronized Set get(ActiveMQDestination key) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            HashSet<Set> answer = new HashSet<Set>(destinations.length);
            for (int i = 0; i < destinations.length; ++i) {
                ActiveMQDestination childDestination = destinations[i];
                Set value = this.get(childDestination);
                if (value instanceof Set) {
                    answer.addAll(value);
                    continue;
                }
                if (value == null) continue;
                answer.add(value);
            }
            return answer;
        }
        return this.findWildcardMatches(key);
    }

    public synchronized void put(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ActiveMQDestination childDestination = destinations[i];
                this.put(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.rootNode.add(paths, 0, value);
    }

    public synchronized void remove(ActiveMQDestination key, Object value) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                ActiveMQDestination childDestination = destinations[i];
                this.remove(childDestination, value);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.rootNode.remove(paths, 0, value);
    }

    public int getRootChildCount() {
        return this.rootNode.getChildCount();
    }

    protected void setEntries(List entries) {
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            Class type = this.getEntryClass();
            if (type.isInstance(element)) {
                DestinationMapEntry entry = (DestinationMapEntry)element;
                this.put(entry.getDestination(), entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Each entry must be an instance of type: " + type.getName() + " but was: " + element);
        }
    }

    protected Class getEntryClass() {
        return DestinationMapEntry.class;
    }

    protected Set findWildcardMatches(ActiveMQDestination key) {
        String[] paths = key.getDestinationPaths();
        HashSet answer = new HashSet();
        this.rootNode.appendMatchingValues(answer, paths, 0);
        return answer;
    }

    public void removeAll(ActiveMQDestination key) {
        if (key.isComposite()) {
            ActiveMQDestination[] destinations = key.getCompositeDestinations();
            for (int i = 0; i < destinations.length; ++i) {
                this.removeAll(destinations[i]);
            }
            return;
        }
        String[] paths = key.getDestinationPaths();
        this.rootNode.removeAll(paths, 0);
    }

    public Object chooseValue(ActiveMQDestination destination) {
        Set set = this.get(destination);
        if (set == null || set.isEmpty()) {
            return null;
        }
        TreeSet sortedSet = new TreeSet(set);
        return sortedSet.last();
    }
}

