/*
 * Decompiled with CFR 0.152.
 */
package org.activemq.memory;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.util.Iterator;
import org.activemq.memory.UsageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UsageManager {
    private static final Log log = LogFactory.getLog((Class)UsageManager.class);
    private final UsageManager parent;
    private long limit;
    private long usage;
    private int percentUsage;
    private int percentUsageMinDelta = 10;
    private final Object usageMutex = new Object();
    private final CopyOnWriteArrayList listeners = new CopyOnWriteArrayList();

    public UsageManager() {
        this(null);
    }

    public UsageManager(UsageManager parent) {
        this.parent = parent;
    }

    public void enqueueUsage(long value) throws InterruptedException {
        this.waitForSpace();
        this.increaseUsage(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSpace() throws InterruptedException {
        Object object = this.usageMutex;
        synchronized (object) {
            int i = 0;
            while (this.percentUsage >= 100) {
                this.usageMutex.wait();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseUsage(long value) {
        if (value == 0L) {
            return;
        }
        if (this.parent != null) {
            this.parent.increaseUsage(value);
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.usage += value;
            this.setPercentUsage(this.caclPercentUsage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseUsage(long value) {
        if (value == 0L) {
            return;
        }
        if (this.parent != null) {
            this.parent.decreaseUsage(value);
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.usage -= value;
            this.setPercentUsage(this.caclPercentUsage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.percentUsage >= 100;
        }
    }

    public void addUsageListener(UsageListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeUsageListener(UsageListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLimit() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(long limit) {
        if (this.percentUsageMinDelta < 0) {
            throw new IllegalArgumentException("percentUsageMinDelta must be greater or equal to 0");
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.limit = limit;
            this.setPercentUsage(this.caclPercentUsage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPercentUsage() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.percentUsage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPercentUsageMinDelta() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.percentUsageMinDelta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPercentUsageMinDelta(int percentUsageMinDelta) {
        if (percentUsageMinDelta < 1) {
            throw new IllegalArgumentException("percentUsageMinDelta must be greater than 0");
        }
        Object object = this.usageMutex;
        synchronized (object) {
            this.percentUsageMinDelta = percentUsageMinDelta;
            this.setPercentUsage(this.caclPercentUsage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsage() {
        Object object = this.usageMutex;
        synchronized (object) {
            return this.usage;
        }
    }

    private void setPercentUsage(int value) {
        int oldValue = this.percentUsage;
        this.percentUsage = value;
        if (oldValue != value) {
            this.fireEvent(oldValue, value);
        }
    }

    private int caclPercentUsage() {
        if (this.limit == 0L) {
            return 0;
        }
        return (int)(this.usage * 100L / this.limit / (long)this.percentUsageMinDelta * (long)this.percentUsageMinDelta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(int oldPercentUsage, int newPercentUsage) {
        log.debug((Object)("Memory usage change.  from: " + oldPercentUsage + ", to: " + newPercentUsage));
        if (oldPercentUsage >= 100 && newPercentUsage < 100) {
            Object object = this.usageMutex;
            synchronized (object) {
                this.usageMutex.notifyAll();
            }
        }
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            UsageListener l = (UsageListener)iter.next();
            l.onMemoryUseChanged(this, oldPercentUsage, newPercentUsage);
        }
    }

    public String toString() {
        return "UsageManager: percentUsage=" + this.percentUsage + "%, usage=" + this.usage + " limit=" + this.limit + " percentUsageMinDelta=" + this.percentUsageMinDelta + "%";
    }
}

